//+------------------------------------------------------------------+
//|                                                       TPEHEP.mq4 |
//|                                                   Copyright 2016.|
//+------------------------------------------------------------------+
#property link      "Fedor10_10@mail.ru"
#property version   "1.01"
#property strict
#property indicator_chart_window
#property description " TPEHEP    "
#property description "       "
#property description " , ,     Excel."
#property description "   :  'B'- BUY,  'S'- SELL,  'C'- CLOSE"
#property description "                                   F12  Step-    1 "
#property description "                                   '<'-  , '>'-  "
#property description "                                   'P'-   "
extern string K="+:+:+:+";//  
input bool Traid=true;///
input double Lots   =1.0;// 
input int StopLoss  =100;//StopLoss ( 5-)
input int TakeProfit=40;//TakeProfit ( 5-)
input double Spread=0.0;   // ( 5-) 0 -  
input double Freeze=0.0;   //  ( 5-)
extern string L="+:+:+:+";//  
input bool Vertical =true;///  
input color OpBUY=clrLightSkyBlue;//  BUY
input color OpSELL=clrLightPink;//  SELL
input color ClsAll=clrWhite;    //   
input color TakePr=clrPaleGreen;//    TakeProfit
input color StopLs=clrYellow;   //    StopLoss
extern string M="+:+:+:+";//
input color Zone=clrDarkViolet;    //   
input bool Metka=false;///  
input bool Alerts=false;// 
input int Step=110;//    1 
int    n,bar0,Ordr,Tr,SH,file;
double Ask0,Ask1,Bid0,Bid1,SL,TP,SP,Zm,Lev,LevOrd,LevUp,LevDn,Sum;
string FileName,FileNamo,Namo,Uplev,Oplev,Dnlev;
long   result,resold;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   FileName=Symbol()+"."+IntegerToString(Period())+" ";//    
   if(Traid)//    
     {
      if(Spread==0.0) SP=MarketInfo(Symbol(),MODE_SPREAD);//
      else SP=Spread;
      if(Freeze==0.0) Zm=MarketInfo(Symbol(),MODE_FREEZELEVEL);// 
      else Zm=Freeze;
      Lev=MarketInfo(Symbol(),MODE_STOPLEVEL);// 
      Lev=NormalizeDouble((Lev*Point),Digits);// 
      SL=NormalizeDouble((StopLoss*Point),Digits);//StopLoss
      if(SL<Lev) {SL=Lev; Alert("StopLoss=",SL/Point);}
      TP=NormalizeDouble((TakeProfit*Point),Digits);//TakeProfit
      if(TP<Lev) {TP=Lev; Alert("TakeProfit=",TP/Point);}
      SP=NormalizeDouble((SP*Point),Digits);//
      Zm=NormalizeDouble((Zm*Point),Digits);// 
      if(Digits==3 || Digits==5)//  
        {
         if(SL>1000) Alert("StopLoss  5-   1000");
         if(TP>1000) Alert("TakeProfit  5-   1000");
        }
      else
        {
         if(SL>100) Alert("StopLoss  4-   100");
         if(TP>100) Alert("TakeProfit  4-   100");
        }
      ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0,result);//   
      ObjectCreate("Show1",OBJ_LABEL,0,0,0); //   
      ObjectSet("Show1",OBJPROP_XDISTANCE,result/2-50);
      ObjectSet("Show1",OBJPROP_YDISTANCE,0);
      ObjectSet("Show1",OBJPROP_CORNER,0);
      ObjectSetText("Show1",":",14,"Arial",clrDarkGray);// 
      ObjectCreate("Show2",OBJ_LABEL,0,0,0); //   
      ObjectSet("Show2",OBJPROP_XDISTANCE,result/2+40);
      ObjectSet("Show2",OBJPROP_YDISTANCE,0);
      ObjectSet("Show2",OBJPROP_CORNER,0);
      ObjectSetText("Show2",DoubleToString(0.0,1),14,"Arial",clrBlueViolet);// 
      resold=result;
      file=FileOpen(FileName,FILE_WRITE|FILE_SHARE_READ|FILE_TXT);
      FileWrite(file,"  \t  \t    \t  \t  \t    \t  \t     ");
     }
   ObjectCreate("Zona",OBJ_VLINE,0,Time[0],Close[0]);//   
   ObjectSet("Zona",OBJPROP_STYLE,DRAW_LINE);
   ObjectSet("Zona",OBJPROP_WIDTH,8);
   ObjectSet("Zona",OBJPROP_COLOR,Zone);
   ObjectSet("Zona",OBJPROP_BACK,true);
   ObjectSet("Zona",OBJPROP_TIME1,Time[0]);//  
   ChartRedraw(); //
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   if(Traid) FileClose(file);//  
   ObjectDelete("Zona");
   ObjectDelete("Show1");
   ObjectDelete("Show2");
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   return(rates_total);//
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,         //  
                  const long& lparam,   //    long
                  const double& dparam, //    double
                  const string& sparam) //    string
  {
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
   if(CHARTEVENT_CHART_CHANGE)
     {
      ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0,result);//   
      if(result!=resold) Show(result);
     }
   if(Traid && Ordr!=0 && id==CHARTEVENT_OBJECT_DRAG)
     {
      if(sparam==Uplev)//  
         if(LevUp!=ObjectGet(Uplev,OBJPROP_PRICE1))
            LevUp=MouseUp();//  
      if(sparam==Dnlev)//  
         if(LevDn!=ObjectGet(Dnlev,OBJPROP_PRICE1))
            LevDn=MouseDn();//  
     }
   if(id==CHARTEVENT_KEYDOWN)
     {
      switch(int(lparam))
        {
         case 37: Alert("  "); break;//KEY_LEFT_ARROW
         case 39: Alert("   F12"); break;//KEY_RIGHT_ARROW  F12
         case 66: if(Traid)
           {
            if(Ordr==0)//KEY_BUY
              {
               Ordr=bar0;
               Levl("BUY");//    
               if(Vertical) Vert("BUY",OpBUY);//   BUY
               if(Metka) Metca("BUY",0,OpBUY);//  
              }
            else Alert("  ");
           }
         else if(Tr!=1){Tr=1; Vert("BUY",OpBUY);}//   BUY
         else Alert("   ");
         n++; if(n==1) Namo=TimeToString(Time[Bar()],TIME_DATE);
         break;
         case 67: if(Traid)
           {
            if(Ordr!=0)//KEY_CLOSE
              {
               if(Freez()) break;//  
               Trend("CL",Ordr,ClsAll);// 
               if(Vertical) Vert("CL",ClsAll);//   Cls
               if(Metka) Metca("CL",Ordr,ClsAll);//  
               Prof("CL",Ordr);// 
               Ordr=0; if(Traid) Delet();// 
              }
            else Alert(" ");
           }
         else if(Tr!=0) {Tr=0; Vert("CL",ClsAll);}//   Cls
         else Alert("  ");
         break;
         case 80:
            if(n<1)// 
              {
               if(ChartSaveTemplate(0,FileName+"."))
                  Alert(" ",FileName," "); break;
              }
            else
              {
               if(Traid)//  
                 {
                  FileFlush(file); FileClose(file);
                  FileNamo=FileName+Namo+"-"+TimeToString(Time[Bar()],TIME_DATE)+".xls";
                  if(FileMove(FileName,0,FileNamo,FILE_REWRITE))
                     Alert(" ",FileNamo," "); break;
                 }
               else//  
                 {
                  FileNamo=FileName+Namo+"-"+TimeToString(Time[Bar()],TIME_DATE)+".";
                  if(ChartSaveTemplate(0,FileNamo))
                     Alert(" ",FileNamo," "); break;
                 }
              }
         case 83: if(Traid)
           {
            if(Ordr==0)//KEY_SELL
              {
               Ordr=-bar0;
               Levl("SEL");//    
               if(Vertical) Vert("SEL",OpSELL);//   SELL
               if(Metka) Metca("SEL",0,OpSELL);//  
              }
            else Alert("  ");
           }
         else if(Tr!=-1) {Tr=-1; Vert("SEL",OpSELL);}//   SELL
         else Alert("   ");
         n++; if(n==1) Namo=TimeToString(Time[Bar()],TIME_DATE);
         break;
         case 188: SH++;//KEY_LEFT
         if(SH>WindowBarsPerChart()){Alert("   "); SH=WindowBarsPerChart();}
         break;//   
         case 190: SH--;//KEY_RIGHT
         if(SH<0){Alert("   "); SH=0;}
         break;//    
         default: if(lparam==Step) {ChartNavigate(0,CHART_CURRENT_POS,1); break;}//KEY_Shift
         else Alert("   ",(lparam));
        }
     }
   if(Bar()<=0) {if(n>0) Alert("  "); return;}//  
   bar0=Bar()+SH;//    
   if(Time[bar0]!=ObjectGet("Zona",OBJPROP_TIME1))//  
     {
      Bid0=Close[bar0]; Ask0=Close[bar0]+SP;//   
      Bid1=Open[bar0-1]; Ask1=Open[bar0-1]+SP;//   
      LevStop();//   
      ObjectSet("Zona",OBJPROP_TIME1,Time[bar0]);//  
      ChartRedraw();//
     }
  }
//+------------------------------------------------------------------+
//|                                                        |
//+------------------------------------------------------------------+
void Vert(string cmd,color clr)//  
  {
   cmd+=IntegerToString(n);
   ObjectCreate(cmd,OBJ_VLINE,0,Time[bar0],0);
   ObjectSet(cmd,OBJPROP_STYLE,STYLE_DASH);
   ObjectSet(cmd,OBJPROP_COLOR,clr);
   ObjectSet(cmd,OBJPROP_BACK,true);
   ChartRedraw();//
  }
//+------------------------------------------------------------------+
void Levl(string cmd)//   
  {
   Oplev=cmd;
   if(cmd=="BUY")
     {
      LevOrd=Ask1;// Ask 
      Uplev="TakeProfit"; LevUp=LevOrd+TP;// Bid StopLoss  
      Dnlev="StopLoss"; LevDn=LevOrd-SL;// Bid TakeProfit  
     }
   if(cmd=="SEL")
     {
      LevOrd=Bid1;// Bid 
      Uplev="StopLoss"; LevUp=LevOrd+SL;// Ask TakeProfit  
      Dnlev="TakeProfit"; LevDn=LevOrd-TP;// Ask StopLoss  
     }
   ObjectCreate(Uplev,OBJ_HLINE,0,0,LevUp);
   ObjectSet(Uplev,OBJPROP_STYLE,STYLE_DASHDOT);
   ObjectSet(Uplev,OBJPROP_COLOR,clrOrangeRed);
   ObjectSetInteger(0,Uplev,OBJPROP_BACK,true);
   ObjectSetInteger(0,Uplev,OBJPROP_SELECTED,true);
   ObjectCreate(Oplev,OBJ_HLINE,0,0,LevOrd);
   ObjectSet(Oplev,OBJPROP_STYLE,STYLE_DASHDOT);
   ObjectSet(Oplev,OBJPROP_COLOR,clrLimeGreen);
   ObjectSetInteger(0,Oplev,OBJPROP_BACK,true);
   ObjectCreate(Dnlev,OBJ_HLINE,0,0,LevDn);
   ObjectSet(Dnlev,OBJPROP_STYLE,STYLE_DASHDOT);
   ObjectSet(Dnlev,OBJPROP_COLOR,clrOrangeRed);
   ObjectSetInteger(0,Dnlev,OBJPROP_BACK,true);
   ObjectSetInteger(0,Dnlev,OBJPROP_SELECTED,true);
   ChartRedraw();//
  }
//+------------------------------------------------------------------+
void Metca(string cmd,int ord,color clr)//  
  {
   if(ord==0)// 
     {
      if(cmd=="BUY") Met("Ask"+IntegerToString(n),Time[bar0-1],LevOrd,clr);//Open BUY
      if(cmd=="SEL") Met("Bid"+IntegerToString(n),Time[bar0-1],LevOrd,clr);//Open SELL
     }
   if(ord>0)//  BUY
     {
      if(cmd=="CL") Met("Bid"+IntegerToString(n),Time[bar0-1],Bid1,clr);//ZERO
      if(cmd=="SL") Met("Bid"+IntegerToString(n),Time[bar0],LevDn,clr);//SL
      if(cmd=="TP") Met("Bid"+IntegerToString(n),Time[bar0],LevUp,clr);//TP
     }
   if(ord<0)
     {
      if(cmd=="CL") Met("Ask"+IntegerToString(n),Time[bar0-1],Ask1,clr);//ZERO
      if(cmd=="SL") Met("Ask"+IntegerToString(n),Time[bar0],LevUp,clr);//SL
      if(cmd=="TP") Met("Ask"+IntegerToString(n),Time[bar0],LevDn,clr);//TP
     }
  }
//+------------------------------------------------------------------+
void Met(string nm,datetime tm,double pr,color clr)//  
  {
   ObjectCreate(nm,OBJ_ARROW_LEFT_PRICE,0,tm,pr);
   ObjectSet(nm,OBJPROP_STYLE,STYLE_SOLID);
   ObjectSet(nm,OBJPROP_COLOR,clr);
   ObjectSetInteger(0,nm,OBJPROP_SELECTED,false);
   ObjectSetInteger(0,nm,OBJPROP_SELECTABLE,false);
   ChartRedraw();//
  }
//+------------------------------------------------------------------+
void Trend(string cmd,int ord,color clr)//     
  {
   string name="Tr"+IntegerToString(n);
   if(ord>0)//Ask-Bid
     {
      if(cmd=="CL") Tr(name,ord,Bid1,Time[bar0-1],clr);//Man
      if(cmd=="SL") Tr(name,ord,LevDn,Time[bar0],clr);//SL
      if(cmd=="TP") Tr(name,ord,LevUp,Time[bar0],clr);//TP
     }
   if(ord<0)//Bid-Ask
     {
      if(cmd=="CL") Tr(name,-ord,Ask1,Time[bar0-1],clr);//Man
      if(cmd=="SL") Tr(name,-ord,LevUp,Time[bar0],clr);//SL
      if(cmd=="TP") Tr(name,-ord,LevDn,Time[bar0],clr);//TP
     }
  }
//+------------------------------------------------------------------+
void Tr(string name,int ord,double pr,datetime tm,color clr)//     
  {
   ObjectCreate(name,OBJ_TREND,0,Time[ord-1],LevOrd,tm,pr);
   ObjectSetInteger(0,name,OBJPROP_RAY_RIGHT,false);// (false)   
   ObjectSet(name,OBJPROP_STYLE,STYLE_DOT);
   ObjectSet(name,OBJPROP_COLOR,clr);
   ChartRedraw();//
  }
//+------------------------------------------------------------------+
bool Freez()
  {
   if(Ordr>0)
     {
      if(LevUp<=Bid0+Zm)
        {
         Alert("TakeProfit   ");
         return(true);
        }
      if(LevDn>=Bid0-Zm)
        {
         Alert("StopLoss   ");
         return(true);
        }
     }
   if(Ordr<0)
     {
      if(LevUp<=Ask0+Zm)
        {
         Alert("StopLoss   ");
         return(true);
        }
      if(LevDn>=Ask0-Zm)
        {
         Alert("TakeProfit   ");
         return(true);
        }
     }
   return(false);
  }
//+------------------------------------------------------------------+
void LevStop()
  {
   if(Ordr>0)// BUY
     {
      if(Low[bar0]<=LevDn)//   
        {
         if(Vertical) Vert("SL",StopLs);
         if(Metka) Metca("SL",Ordr,StopLs);
         if(Traid) {Trend("SL",Ordr,StopLs); Prof("SL",Ordr); Delet();}
         if(Alerts) Alert(" StopLoss");
         Ordr=0;
        }
      if(High[bar0]>=LevUp)//   
        {
         if(Vertical) Vert("TP",TakePr);
         if(Metka) Metca("TP",Ordr,TakePr);
         if(Traid) {Trend("TP",Ordr,TakePr); Prof("TP",Ordr); Delet();}
         if(Alerts) Alert(" TakeProfit");
         Ordr=0;
        }
     }
   if(Ordr<0)// SELL
     {
      if(High[bar0]+SP>=LevUp)//   
        {
         if(Vertical) Vert("SL",StopLs);
         if(Metka) Metca("SL",Ordr,StopLs);
         if(Traid) {Trend("SL",Ordr,StopLs); Prof("SL",Ordr); Delet();}
         if(Alerts) Alert(" StopLoss");
         Ordr=0;
        }
      if(Low[bar0]+SP<=LevDn)//   
        {
         if(Vertical) Vert("TP",TakePr);
         if(Metka) Metca("TP",Ordr,TakePr);
         if(Traid) {Trend("TP",Ordr,TakePr); Prof("TP",Ordr); Delet();}
         if(Alerts) Alert(" TakeProfit");
         Ordr=0;
        }
     }
  }
//+------------------------------------------------------------------+
void Prof(string cmd,int ord)//
  {
   if(ord>0)// BUY   Bid-Ask
     {
      if(cmd=="CL") Write(ord,"CL_BUY",Time[bar0-1],Bid1,NormalizeDouble(Bid1-LevOrd,Digits));//Man
      if(cmd=="SL") Write(ord,"SL_BUY",Time[bar0],LevDn,NormalizeDouble(LevDn-LevOrd,Digits));//SL
      if(cmd=="TP") Write(ord,"TP_BUY",Time[bar0],LevUp,NormalizeDouble(LevUp-LevOrd,Digits));//TP
     }
   if(ord<0)// SELL Ask-Bid
     {
      if(cmd=="CL") Write(ord,"CL_SEL",Time[bar0-1],Ask1,NormalizeDouble(LevOrd-Ask1,Digits));//Man
      if(cmd=="SL") Write(ord,"SL_SEL",Time[bar0],LevUp,NormalizeDouble(LevOrd-LevUp,Digits));//SL
      if(cmd=="TP") Write(ord,"TP_SEL",Time[bar0],LevDn,NormalizeDouble(LevOrd-LevDn,Digits));//TP
     }
  }
//+------------------------------------------------------------------+
void Write(int ord,string nm,datetime tm,double clr,double pr)//  
  {
   Sum+=NormalizeDouble(pr*Lots/(10*Point),2);// 
   color Cl=clrBlueViolet; if(Sum<0.0) Cl=clrCrimson;// 
   datetime T0=Time[fabs(ord)-1];//  
   FileWrite(file,n,"\t",TimeToStr(T0,TIME_MINUTES),"\t",Rus(DoubleToString(LevOrd,Digits)),"\t",nm,"\t",
             TimeToStr(tm,TIME_MINUTES),"\t",Rus(DoubleToString(clr,Digits)),"\t",
             IntegerToString(int(pr/Point)),"\t",Rus(DoubleToString(Sum,2)));
   ObjectSetText("Show2",DoubleToString(Sum,2),14,"Arial",Cl);//  
   ChartRedraw();//
  }
//+------------------------------------------------------------------+
string Rus(string ru)// (.)(,)  Excel
  {
   StringReplace(ru,".",",");
   return ru;
  }
//+------------------------------------------------------------------+
int Bar()//     .
  {
   long res=0;//  
   res+=ChartGetInteger(0,CHART_FIRST_VISIBLE_BAR,0,res);//    
   res-=WindowBarsPerChart()+1;//   
   return(int(res));//---    
  }
//+------------------------------------------------------------------+
void Show(long res)//   
  {
   ObjectSet("Show1",OBJPROP_XDISTANCE,res/2-50);
   ObjectSet("Show2",OBJPROP_XDISTANCE,res/2+40);
   ChartRedraw();//
   resold=result;
  }
//+------------------------------------------------------------------+
void Delet()// 
  {
   ObjectDelete(Uplev);//  
   ObjectDelete(Oplev);//  
   ObjectDelete(Dnlev);//  
   ChartRedraw();//
  }
//+------------------------------------------------------------------+
double MouseUp()
  {
   if(Freez()) ObjectSet(Uplev,OBJPROP_PRICE1,LevUp);//    
   else
     {
      if(Ordr>0 && ObjectGet(Uplev,OBJPROP_PRICE1)<=Ask0+Lev)//    
        {
         Alert("TakeProfit= ",Lev,"+1");
         ObjectSet(Uplev,OBJPROP_PRICE1,(Ask0+Lev+Point));// TakeProfit  
        }
      if(Ordr<0 && ObjectGet(Uplev,OBJPROP_PRICE1)<=Bid0+Lev)//    
        {
         Alert("StopLoss= ",Lev,"+1");
         ObjectSet(Uplev,OBJPROP_PRICE1,(Bid0+Lev+Point));// StopLoss  
        }
     }
   ChartRedraw();//
   return(ObjectGet(Uplev,OBJPROP_PRICE1));//   
  }
//+------------------------------------------------------------------+
double MouseDn()
  {
   if(Freez()) ObjectSet(Dnlev,OBJPROP_PRICE1,LevDn);//    
   else
     {
      if(Ordr>0 && ObjectGet(Dnlev,OBJPROP_PRICE1)>=Ask0-Lev)//    
        {
         Alert("StopLoss= ",Lev,"+1");
         ObjectSet(Dnlev,OBJPROP_PRICE1,(Ask0-Lev-Point));// StopLoss  
        }
      if(Ordr<0 && ObjectGet(Dnlev,OBJPROP_PRICE1)>=Bid0-Lev)//    
        {
         Alert("StopLoss= ",Lev,"+1");
         ObjectSet(Dnlev,OBJPROP_PRICE1,(Bid0-Lev-Point));// TakeProfit  
        }
     }
   ChartRedraw();//
   return(ObjectGet(Dnlev,OBJPROP_PRICE1));//   
  }
//+------------------------------------------------------------------+
