//+---------------------------------------------------------------------+
//|                                                           F_RSI.mq5 | 
//|                                Copyright  2015, Yuriy Tokman (YTG) |
//|                                                  http://ytg.com.ua/ |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2015, Yuriy Tokman (YTG)"
#property link      "http://ytg.com.ua/"
#property description " RSI   "
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----    3
#property indicator_buffers 3 
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|     RSI Cloud    |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_FILLING
//----      
#property indicator_color1  clrLavender
//----   
#property indicator_label1  "RSI Cloud"
//+----------------------------------------------+
//|    RSI           |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        DeepPink
#property indicator_color2  clrDeepPink
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----   
#property indicator_label2  "RSI"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1  70
#property indicator_level2  50
#property indicator_level3  30
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2,XMA3;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint PeriodRSI=7;                               //   RSI
input Smooth_Method XMA_Method=MODE_SMMA;             //  
input int XPhase=15; //  
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input double Dev=1;                                   // 
input ENUM_APPLIED_PRICE  Applied_price=PRICE_CLOSE;  //    handle
input int Shift=0;                                    //        
//+----------------------------------------------+
//----   ,   
//----      
double Line1Buffer[];
double Line2Buffer[];
double Line3Buffer[];
//----      
int min_rates_total,min_rates_1,min_rates_2;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_1=1;
   min_rates_2=min_rates_1+GetStartBars(XMA_Method,PeriodRSI,XPhase);
   min_rates_total=min_rates_2+int(PeriodRSI);
//----    Line2Buffer[]   
   SetIndexBuffer(0,Line2Buffer,INDICATOR_DATA);
//----    Line3Buffer[]   
   SetIndexBuffer(1,Line3Buffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);

//----    Line1Buffer[]   
   SetIndexBuffer(2,Line1Buffer,INDICATOR_DATA);
//----    3    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);

//----      
   string shortname;
   StringConcatenate(shortname,"F_RSI(",PeriodRSI,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double rl,rsi,ps,ng,srsi,sqr,s_dv;
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_1; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      rl=PriceSeries(Applied_price,bar,open,low,high,close)-PriceSeries(Applied_price,bar-1,open,low,high,close);
      ps=MathMax(0,rl);
      ng=-MathMin(0,rl);
      ps=XMA1.XMASeries(min_rates_1,prev_calculated,rates_total,XMA_Method,XPhase,PeriodRSI,ps,bar,false);
      ng=XMA2.XMASeries(min_rates_1,prev_calculated,rates_total,XMA_Method,XPhase,PeriodRSI,ng,bar,false);
      if(!ng || !(1+ps/ng)) rsi=100.0;
      else rsi=100.0-100.0/(1+ps/ng);
      Line1Buffer[bar]=rsi;
      srsi=XMA3.XMASeries(min_rates_2,prev_calculated,rates_total,MODE_SMA_,0,PeriodRSI,rsi,bar,false);
      sqr=0;
      for(int kkk=int(PeriodRSI)-1; kkk>=0; kkk--)
        {
         int index=MathMax(0,bar-kkk);
         sqr+=(Line1Buffer[index]-srsi)*(Line1Buffer[index]-srsi);
        }
      s_dv=MathPow(sqr/PeriodRSI,0.5);
      Line2Buffer[bar]=50+Dev*s_dv;
      Line3Buffer[bar]=50-Dev*s_dv;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
