//+---------------------------------------------------------------------+
//|                                                     ATRSmoothed.mq5 |
//|                            Copyright  2005, Luis Guilherme Damiani |
//|                                         http://www.damianifx.com.br |
///+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2005, Luis Guilherme Damiani"
#property link      "http://www.damianifx.com.br"
#property description "ATR Channels"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_HISTOGRAM
//----       - 
#property indicator_color1 clrBlueViolet
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "ATRSmoothed"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0                    //        
//+-----------------------------------+
//|          |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int    ATRPeriod=14;
input Smooth_Method XMA_Method=MODE_JJMA; //  
input int XLength=5; //   
input int XPhase=15; //  
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int Shift=0; //      
//+-----------------------------------+
//----   ,    
//----      
double ExtLineBuffer[];
//----      
int ATR_Handle;
//----      
int min_rates_ATR,min_rates_total;
//+------------------------------------------------------------------+   
//| ATR Channels indicator initialization function                   | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----    ATR
   ATR_Handle=iATR(NULL,PERIOD_CURRENT,ATRPeriod);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----     
   min_rates_ATR=int(ATRPeriod);
   min_rates_total=min_rates_ATR+GetStartBars(XMA_Method,XLength,XPhase)+1;
//----       
   XMA.XMALengthCheck("XLength",XLength);
   XMA.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//----      
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----          
   ArraySetAsSeries(ExtLineBuffer,true);
//----      
   string shortname;
   string Smooth=XMA.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"ATRSmoothed(",ATRPeriod," ",XLength," ",Smooth,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| ATR Channels iteration function                                  | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----       
   double Range[];
//----        
   int to_copy,limit,bar,maxbar;
   maxbar=rates_total-1-min_rates_ATR;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=maxbar; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+1;
//----       Range[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,Range)<=0) return(RESET);
//----         
   ArraySetAsSeries(Range,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ExtLineBuffer[bar]=XMA.XMASeries(maxbar,prev_calculated,rates_total,XMA_Method,XPhase,XLength,Range[bar],bar,true);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
