//+------------------------------------------------------------------+
//|                                             3D_OscilatorSign.mq5 |
//|                                   Copyright  2005, Luis Damiani |
//|                                                                  |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2005, Luis Damiani"
//----    
#property link      ""
//----   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrMagenta
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "3D_Oscilator Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrLime
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "3D_Oscilator Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int D1RSIPer=13;
input int D2StochPer=8;
input int D3tunnelPer=8;
input double hot=0.4;
input int sigsmooth=4;
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[];
double BuyBuffer[];
//---
double sk,sk2;
int ss,min_rates_total,ATR_Handle,RSI_Handle,CCI_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----   
   ss=sigsmooth;
   if(ss<2) ss=2;
   sk = 2.0 / (ss + 1.0);
   sk2=2.0/(ss*0.8+1.0);
   int ATR_Period=15;
   min_rates_total=int(D1RSIPer+D2StochPer+D2StochPer+hot+sigsmooth);
   min_rates_total=MathMax(min_rates_total,ATR_Period)+1;

//----   
   RSI_Handle=iRSI(NULL,0,D1RSIPer,PRICE_CLOSE);
   if(RSI_Handle==INVALID_HANDLE)
     {
      Print("      iRSI");
      return(INIT_FAILED);
     }
//----   
   CCI_Handle=iCCI(NULL,0,D3tunnelPer,PRICE_TYPICAL);
   if(CCI_Handle==INVALID_HANDLE)
     {
      Print("      iCCI");
      return(INIT_FAILED);
     }
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }

//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,159);
//----       
   ArraySetAsSeries(SellBuffer,true);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);

//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//----       
   ArraySetAsSeries(BuyBuffer,true);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string short_name="3D OscillatorSign";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---   
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(RSI_Handle)<rates_total
      || BarsCalculated(CCI_Handle)<rates_total
      || BarsCalculated(ATR_Handle)<rates_total
      ||rates_total<min_rates_total) return(RESET);

//----    
   int to_copy,limit,bar;
   double rsi,maxrsi,minrsi,storsi,E3D,RSI[],CCI[],ATR[],rangrsi,ind,sig;
   static double prev_ind,prev_sig;

//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      to_copy=rates_total; //    
      limit=rates_total-min_rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
      to_copy=limit+D2StochPer+3; //    
     }

//----         
   ArraySetAsSeries(RSI,true);
   ArraySetAsSeries(CCI,true);
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);

//----      
   if(CopyBuffer(RSI_Handle,0,0,to_copy,RSI)<=0) return(RESET);
   to_copy=limit+1;
   if(CopyBuffer(CCI_Handle,0,0,to_copy,CCI)<=0) return(RESET);
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      rsi=RSI[bar];
      maxrsi=rsi;
      minrsi=rsi;

      for(int iii=bar+D2StochPer; iii>=bar; iii--)
        {
         rsi=RSI[iii];
         if(rsi>maxrsi) maxrsi=rsi;
         if(rsi<minrsi) minrsi=rsi;
        }

      rangrsi=maxrsi-minrsi;
      if(rangrsi==0) storsi=0.0;
      else storsi=(rsi-minrsi)/((maxrsi-minrsi)*200)-100;
      E3D=hot*CCI[bar]+(1.0-hot)*storsi;

      ind=sk*E3D+(1.0-sk)*prev_ind;
      sig=sk2*prev_ind+(1.0-sk2)*prev_sig;

      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;

      if(ind>sig && prev_ind<prev_sig) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
      if(ind<sig && prev_ind>prev_sig) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;

      if(bar)
        {
         prev_ind=ind;
         prev_sig=sig;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
