//+---------------------------------------------------------------------+ 
//|                                                  ColorRMACD_HTF.mq5 | 
//|                                  Copyright  2015, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\MQL5\Include         |
//+---------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.60"
//----     
#property indicator_separate_window 
//----    4
#property indicator_buffers 4 
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                            //        
#define INDICATOR_NAME "ColorRMACD"        //    
//+----------------------------------------------+
//|     1            |
//+----------------------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 clrGray,clrTeal,clrBlueViolet,clrIndianRed,clrMagenta
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1 "RMACD"
//+----------------------------------------------+
//|     2            |
//+----------------------------------------------+
//----      
#property indicator_type2 DRAW_COLOR_LINE
//----      
#property indicator_color2 clrGray,clrLime,clrRed
//----   -  
#property indicator_style2 STYLE_SOLID
//----     3
#property indicator_width2 3
//----    
#property indicator_label2  "Signal Line"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4; //  
input uint Fast_RVI=12;  //   
input uint Slow_TRVI=26; //   
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK; // 
input Smooth_Method Signal_Method=MODE_JJMA; //    
input uint Signal_XMA=9; //   
input int Signal_Phase=100; //   
//----    -100 ... +100,
//----     ;
input uint AlertCount=0; //   
input int Shift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double IndBuffer1[],ColorIndBuffer1[];
double IndBuffer2[],ColorIndBuffer2[];
//----   
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int Ind_Handle;
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    ColorRMACD       ");
      return(INIT_FAILED);
     }
//----   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//----    ColorRMACD
   Ind_Handle=iCustom(Symbol_,TimeFrame,"ColorRMACD",Fast_RVI,Slow_TRVI,VolumeType,Signal_Method,Signal_XMA,Signal_Phase,AlertCount);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      ColorRMACD");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,IndBuffer1,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(IndBuffer1,true);

//----     ,     
   SetIndexBuffer(1,ColorIndBuffer1,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer1,true);

//----      
   SetIndexBuffer(2,IndBuffer2,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(IndBuffer2,true);

//----     ,     
   SetIndexBuffer(3,ColorIndBuffer2,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer2,true);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,INDICATOR_NAME);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//----    
   double Ind[1],Col[1];
   int limit,bar;
   datetime IndTime[1];
   static double LastInd=0.0;
   static uint LastCountBar;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       
//----         
   ArraySetAsSeries(time,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuffer1[bar]=EMPTY_VALUE;
      IndBuffer2[bar]=EMPTY_VALUE;
      //----       IndTime
      if(CopyTime(Symbol_,TimeFrame,time[bar],1,IndTime)<=0) return(RESET);
      //----      
      if(time[bar]>=IndTime[0] && time[bar+1]<IndTime[0])
        {
         LastCountBar=bar;
         //----       Ind
         if(CopyBuffer(Ind_Handle,0,time[bar],1,Ind)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,1,time[bar],1,Col)<=0) return(RESET);
         //----
         IndBuffer1[bar]=Ind[0];
         ColorIndBuffer1[bar]=Col[0];
         //----       Ind
         if(CopyBuffer(Ind_Handle,2,time[bar],1,Ind)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,3,time[bar],1,Col)<=0) return(RESET);
         //----
         IndBuffer2[bar]=Ind[0];
         ColorIndBuffer2[bar]=Col[0];
        }
      else
        {
         IndBuffer1[bar]=IndBuffer1[bar+1];
         ColorIndBuffer1[bar]=ColorIndBuffer1[bar+1];
         IndBuffer2[bar]=IndBuffer2[bar+1];
         ColorIndBuffer2[bar]=ColorIndBuffer2[bar+1];
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
