//+---------------------------------------------------------------------+ 
//|                                                      ColorRMACD.mq5 | 
//|                                  Copyright  2010, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----    4
#property indicator_buffers 4 
//----     
#property indicator_plots   2
//+-----------------------------------+
//|    1  |
//+-----------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 clrGray,clrTeal,clrBlueViolet,clrIndianRed,clrMagenta
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1 "RMACD"
//+-----------------------------------+
//|    2  |
//+-----------------------------------+
//----      
#property indicator_type2 DRAW_COLOR_LINE
//----      
#property indicator_color2 clrGray,clrLime,clrRed
//----   -  
#property indicator_style2 STYLE_DASHDOTDOT
//----     3
#property indicator_width2 3
//----    
#property indicator_label2  "Signal Line"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|          |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint Fast_RVI=12;  //   
input uint Slow_TRVI=26; //   
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK; // 
input Smooth_Method Signal_Method=MODE_JJMA; //    
input uint Signal_XMA=9; //   
input int Signal_Phase=100; //   
//----    -100 ... +100,
//----     ;
input uint AlertCount=0; //   
//+-----------------------------------+
//----       
int RVI_Handle,TRVI_Handle;
//----      
int min_rates_total,min_rates;
//----   ,    
//----      
double RMACDBuffer[],SignBuffer[],ColorRMACDBuffer[],ColorSignBuffer[];
//+------------------------------------------------------------------+
//|   iPriceSeries                                    |
//|   Moving_Average                                   | 
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh> 
//+------------------------------------------------------------------+    
//| RMACD indicator initialization function                          | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates=int(MathMax(Fast_RVI,Slow_TRVI+8));
   min_rates_total=min_rates+XMA1.GetStartBars(Signal_Method,Signal_XMA,Signal_Phase);
//----    RVI
   RVI_Handle=iRVI(NULL,0,Fast_RVI);
   if(RVI_Handle==INVALID_HANDLE) Print("     RVI");
//----    TRVI
   TRVI_Handle=iCustom(NULL,0,"TRVI",Slow_TRVI,VolumeType,0);
   if(TRVI_Handle==INVALID_HANDLE) Print("     TRVI");

//----    RMACDBuffer   
   SetIndexBuffer(0,RMACDBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(RMACDBuffer,true);

//----     ,     
   SetIndexBuffer(1,ColorRMACDBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorRMACDBuffer,true);

//----    SignBuffer   
   SetIndexBuffer(2,SignBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(SignBuffer,true);

//----     ,     
   SetIndexBuffer(3,ColorSignBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorSignBuffer,true);

//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates+1);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total+1);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----       
   XMA1.XMALengthCheck("Fast_RVI", Fast_RVI);
   XMA1.XMALengthCheck("Slow_TRVI", Slow_TRVI);
   XMA1.XMALengthCheck("Signal_XMA", Signal_XMA);
//----       
   XMA1.XMAPhaseCheck("Signal_Phase",Signal_Phase,Signal_Method);

//----      
   string shortname;
   string Smooth=XMA1.GetString_MA_Method(Signal_Method);
   StringConcatenate(shortname,"RMACD( ",Fast_RVI,", ",Slow_TRVI,", ",Smooth,", ",Signal_XMA," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| RMACD iteration function                                         | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(RVI_Handle)<rates_total
      || BarsCalculated(TRVI_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//----    
   int to_copy,limit,bar,maxbar;
   double RVI[],TRVI[];
//----
   static uint UpCount,DnCount;
//----       
   double rmacd,sign_xma;
//----
   maxbar=rates_total-1-min_rates;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=maxbar; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//----
   to_copy=limit+1;
//----      
   if(CopyBuffer(RVI_Handle,MAIN_LINE,0,to_copy,RVI)<=0) return(RESET);
   if(CopyBuffer(TRVI_Handle,SIGNAL_LINE,0,to_copy,TRVI)<=0) return(RESET);
//----         
   ArraySetAsSeries(RVI,true);
   ArraySetAsSeries(TRVI,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      rmacd=RVI[bar]-TRVI[bar];
      sign_xma=XMA1.XMASeries(maxbar,prev_calculated,rates_total,Signal_Method,Signal_Phase,Signal_XMA,rmacd,bar,true);
      //----            
      RMACDBuffer[bar]= rmacd;
      SignBuffer[bar] = sign_xma;
     }
//----
   if(prev_calculated>rates_total || prev_calculated<=0) limit--;
//----     RMACD
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ColorRMACDBuffer[bar]=0;
      //----
      if(RMACDBuffer[bar]>0)
        {
         if(RMACDBuffer[bar]>RMACDBuffer[bar+1]) ColorRMACDBuffer[bar]=1;
         if(RMACDBuffer[bar]<RMACDBuffer[bar+1]) ColorRMACDBuffer[bar]=2;
        }
      //----
      if(RMACDBuffer[bar]<0)
        {
         if(RMACDBuffer[bar]<RMACDBuffer[bar+1]) ColorRMACDBuffer[bar]=3;
         if(RMACDBuffer[bar]>RMACDBuffer[bar+1]) ColorRMACDBuffer[bar]=4;
        }
     }
//----
   if(prev_calculated>rates_total || prev_calculated<=0) limit=rates_total-1-min_rates_total-1;
//----     
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ColorSignBuffer[bar]=0;
      if(RMACDBuffer[bar]>SignBuffer[bar+1]) ColorSignBuffer[bar]=1;
      if(RMACDBuffer[bar]<SignBuffer[bar+1]) ColorSignBuffer[bar]=2;
     }
//----     
   if(rates_total!=prev_calculated)
     {
      UpCount=0;
      DnCount=0;
     }
//----
   int bar1=1;
   int bar2=2;
//----    
   if(UpCount<AlertCount && ColorSignBuffer[bar1]==2 && ColorSignBuffer[bar2]==1)
     {
      UpCount++;
      Alert("RMACD  "+Symbol()+EnumToString(PERIOD_CURRENT)+": ""   "+Symbol());
     }
//----    
   if(DnCount<AlertCount && ColorSignBuffer[bar1]==1 && ColorSignBuffer[bar2]==2)
     {
      DnCount++;
      Alert("RMACD  "+Symbol()+EnumToString(PERIOD_CURRENT)+": ""   "+Symbol());
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
