//+------------------------------------------------------------------+
//|                                                    IsSession.mqh |
//|                               Copyright 2015, Gruzdev Konstantin |
//|                            https://login.mql5.com/ru/users/Lizar |
//+------------------------------------------------------------------+
#property copyright     "Copyright 2015, Gruzdev Konstantin"
#property link          "https://login.mql5.com/ru/users/Lizar"
#property version       "1.00"
//---
#define   SECONDS_DAY   86400    //     
//---
#include <Object.mqh>            //     
//+------------------------------------------------------------------+
//| Class CIsSession.                                                |
//| Appointment:     ().   |
//+------------------------------------------------------------------+
class CIsSession : public CObject
  {
private:
   long              m_begin;          //    ( )  
   long              m_end;            //    ( )  
   long              m_current;        //      
   MqlDateTime       m_scurrent;       //       
   uchar             m_days_week;      //  ,      (0  - , ..., 6  - ).
                                       //     0,      .
                                       //     1,      .
   bool              m_is_session;     //       ():
                                       //    true  -    ;
                                       //    false -    .
   bool              m_is_daily;       //   ; ,  
                                       //       1970.01.01
   //    true  -  ;
   //    false -      .
   bool              m_type;           //   : 
                                       //    true  -       , m_begin<m_end;
   //    false -        , m_begin>m_end.
public:
   void              CIsSession(void);
   void              CIsSession(const datetime begin_session,
                                const datetime end_session,
                                const bool     permit_monday     = true,
                                const bool     permit_tuesday    = true,
                                const bool     permit_wednesday  = true,
                                const bool     permit_thursday   = true,
                                const bool     permit_friday     = true,
                                const bool     permit_saturday   = false,
                                const bool     permit_sunday     = false);
   void             ~CIsSession(void) {};
   //---  :
   void              Init(const datetime begin_session,
                          const datetime end_session);
   void              Init(const int      index_day,
                          const bool     permit_trade);
   //---      :
   bool              IsSession(void);
  };
//+------------------------------------------------------------------+
//|  .                                              |
//| INPUT:  no.                                                      |
//| OUTPUT: no.                                                      |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
void CIsSession::CIsSession(void)
  {
   m_is_daily = true;                                                   //    , true - 
   m_begin    = 0;                                                      //    ( )  
   m_end      = SECONDS_DAY-1;                                          //    ( )  
   m_type     = true;                                                   //   
   m_days_week= B'11111111';                                            //  ,      
  }
//+------------------------------------------------------------------+
//|   .                              |
//| INPUT:  begin_session     -                  |
//|         end_session       -                   |
//|         permit_sunday     -       |
//|         permit_monday     -       |
//|         permit_tuesday    -          |
//|         permit_wednesday  -             |
//|         permit_thursday   -           |
//|         permit_friday     -           |
//|         permit_saturday   -           |
//| OUTPUT: no.                                                      |
//| REMARK:    "permit..."  true,        |
//|             , false - .       |
//+------------------------------------------------------------------+
void CIsSession::CIsSession(const datetime begin_session,
                            const datetime end_session,
                            const bool     permit_monday     = true,
                            const bool     permit_tuesday    = true,
                            const bool     permit_wednesday  = true,
                            const bool     permit_thursday   = true,
                            const bool     permit_friday     = true,
                            const bool     permit_saturday   = false,
                            const bool     permit_sunday     = false)
  {
   Init(begin_session,end_session);
   Init(0,permit_sunday);
   Init(1,permit_monday);
   Init(2,permit_tuesday);
   Init(3,permit_wednesday);
   Init(4,permit_thursday);
   Init(5,permit_friday);
   Init(6,permit_saturday);
  }
//+------------------------------------------------------------------+
//|       .    |
//| INPUT:  begin_session -   .                  |
//|         end_session   -   .                   |
//| OUTPUT: no.                                                      |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
void CIsSession::Init(const datetime begin_session,
                      const datetime end_session)
  {
   m_is_daily = (begin_session/SECONDS_DAY+end_session/SECONDS_DAY)==0; // /   , true - 
   m_begin    = begin_session;                                          //    ( )  
   m_end      = end_session;                                            //    ( )  
   m_type     = m_begin<m_end;                                          //   
  }
//+------------------------------------------------------------------+
//|    /      |
//|  .                                                     |
//| INPUT:  index_day    -                            |
//|                        (0 - , ..., 6 - )       |
//|         permit_trade - /       |
//| OUTPUT: no.                                                      |
//| REMARK:    true,         |
//|         , false - .                            |
//+------------------------------------------------------------------+
void CIsSession::Init(const int  index_day,
                      const bool permit_trade)
  {
//---     :
   m_days_week &=uchar(~(1<<index_day));                                //   
   m_days_week |=uchar(permit_trade<<index_day);                        //   
  }
//+------------------------------------------------------------------+
//|  ,         |
//|   ().                                   |
//| INPUT:  no.                                                      |
//| OUTPUT: true -      .         |
//|         false -     .     |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CIsSession::IsSession(void)
  {
//---     :
   m_current=TimeCurrent(m_scurrent);
//---        :
   m_is_session=m_days_week&(1<<m_scurrent.day_of_week);
//---
   if(m_is_session)
     {
      //---  ,   :
      if(m_is_daily) m_current%=SECONDS_DAY;
      //--- /  :
      m_is_session=m_begin<=m_current;             //       ...
      //---  m_is_session     : 
      if(m_type) m_is_session &= m_current<=m_end;   // ...    
      else       m_is_session |= m_current<=m_end;   // ...    
     }
//--- :
   return m_is_session;
  }
//+------------------------------------------------------------------+
