//+------------------------------------------------------------------+
//|                                                JMACandleSign.mq5 |
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
#property description "       JMA,   Open  Close   "
//----   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrDeepPink
//---    1  2
#property indicator_width1  2
//---    
#property indicator_label1  "JMACandle Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrDodgerBlue
//---    2  2
#property indicator_width2  2
//---    
#property indicator_label2 "JMACandle Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int JLength=7;  //  
input int JPhase=100; //  
//----    -100 ... +100,
//----     ;
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[];
double BuyBuffer[];
//----      
int min_rates_total;
//----      
int O_Handle,C_Handle,ATR_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----    
   min_rates_total=30+1;
   int ATR_Period=15;
   min_rates_total=int(MathMax(min_rates_total,ATR_Period))+1;
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----   
   enum Applied_price_ // 
     {
      PRICE_CLOSE_ = 1,     //PRICE_CLOSE
      PRICE_OPEN_ = 2       //PRICE_OPEN
     };
//----    JMA
   O_Handle=iCustom(NULL,0,"JMA",JLength,JPhase,PRICE_OPEN_,0,0);
   if(O_Handle==INVALID_HANDLE)
     {
      Print("      iJMA[OPEN]!");
      return(INIT_FAILED);
     }
//----
   C_Handle=iCustom(NULL,0,"JMA",JLength,JPhase,PRICE_CLOSE_,0,0);
   if(C_Handle==INVALID_HANDLE)
     {
      Print("      iJMA[CLOSE]!");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,172);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,172);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string short_name="JMACandleSign";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(O_Handle)<rates_total
      || BarsCalculated(C_Handle)<rates_total
      || BarsCalculated(ATR_Handle)<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//----    
   int to_copy,limit,bar;
   double ATR[],FOpen[],FClose[];
//----         limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-2; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//----
   to_copy=limit+2;
//----      
   if(CopyBuffer(O_Handle,0,0,to_copy,FOpen)<=0) return(RESET);
   if(CopyBuffer(C_Handle,0,0,to_copy,FClose)<=0) return(RESET);
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//---         
   ArraySetAsSeries(FOpen,true);
   ArraySetAsSeries(FClose,true);
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//----      
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      if(FOpen[bar+1]>=FClose[bar+1] && FOpen[bar]<FClose[bar]) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
      if(FOpen[bar+1]<=FClose[bar+1] && FOpen[bar]>FClose[bar]) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
