//+------------------------------------------------------------------+
//|                                                    WPRCandle.mq5 |
//|                                       Copyright  2005, Dark Han |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2005, Dark Han"
//----    
#property link      "http://www.metaquotes.net/"
#property description "Williams Percent Range"
//----   
#property version   "1.00"
//----       
#property indicator_maximum 0
#property indicator_minimum -100
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 5
//----     
#property indicator_plots   1
//----      
#property indicator_type1   DRAW_COLOR_CANDLES
#property indicator_color1   clrDeepPink,clrBlue,clrTeal
//----   
#property indicator_label1  "WPRCandle Open;WPRCandle High;WPRCandle Low;WPRCandle Close"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1  -70
#property indicator_level2  -50
#property indicator_level3  -30
#property indicator_levelcolor clrBlueViolet
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint ExtWPRPeriod=11;
input int Shift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double ExtOpenBuffer[];
double ExtHighBuffer[];
double ExtLowBuffer[];
double ExtCloseBuffer[];
double ExtColorBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(ExtWPRPeriod);
//----      
   string shortname;
   StringConcatenate(shortname,"WPRCandle(",ExtWPRPeriod,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----      
   SetIndexBuffer(0,ExtOpenBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtHighBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLowBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,ExtCloseBuffer,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(4,ExtColorBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ExtOpenBuffer,true);
   ArraySetAsSeries(ExtHighBuffer,true);
   ArraySetAsSeries(ExtLowBuffer,true);
   ArraySetAsSeries(ExtCloseBuffer,true);
   ArraySetAsSeries(ExtColorBuffer,true);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----    
   int limit,bar;
   double range,HH,LL;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//----         
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ExtOpenBuffer[bar]=ExtHighBuffer[bar]=ExtLowBuffer[bar]=ExtCloseBuffer[bar]=50;
      HH=high[ArrayMaximum(high,bar,ExtWPRPeriod)];
      LL=low[ArrayMinimum(low,bar,ExtWPRPeriod)];
      range=HH-LL;
      //----
      if(!CompareDouble(range,0.0))
        {
         ExtOpenBuffer[bar]=-100*(HH-open[bar])/range;
         ExtCloseBuffer[bar]=-100*(HH-close[bar])/range;
         ExtHighBuffer[bar]=-100*(HH-high[bar])/range;
         ExtLowBuffer[bar]=-100*(HH-low[bar])/range;
        }
      //----
      if(ExtOpenBuffer[bar]<ExtCloseBuffer[bar]) ExtColorBuffer[bar]=2.0;
      else if(ExtOpenBuffer[bar]>ExtCloseBuffer[bar]) ExtColorBuffer[bar]=0.0;
      else ExtColorBuffer[bar]=1.0;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                             |
//+------------------------------------------------------------------+
bool CompareDouble(double Number1,double Number2)
  {
//----
   bool Compare=NormalizeDouble(Number1-Number2,8)==0;
//----
   return(Compare);
  }
//+------------------------------------------------------------------+
