//+------------------------------------------------------------------+
//|                                                         WPR3.mq5 |
//|                                       Copyright  2005, Dark Han |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2005, Dark Han"
//----    
#property link      "http://www.metaquotes.net/"
#property description "Williams Percent Range"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 3 
//----    
#property indicator_plots   3
//----       
#property indicator_maximum 0
#property indicator_minimum -100
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1 clrOliveDrab
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "High WPR"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----        
#property indicator_color2 clrGray
//----   -  
#property indicator_style2  STYLE_SOLID
//----     1
#property indicator_width2  1
//----   
#property indicator_label2  "Close WPR"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//----     
#property indicator_type3   DRAW_LINE
//----        
#property indicator_color3 clrPaleVioletRed
//----   -  
#property indicator_style3  STYLE_SOLID
//----     1
#property indicator_width3  1
//----   
#property indicator_label3  "Low WPR"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 -30
#property indicator_level2 -70
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum ENUM_APPLIED_PRICE_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_            //PRICE_LOW
  };
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint ExtWPRPeriod=11;                       //  
input int Shift = 0;                              //      
//+----------------------------------------------+
//----   ,    
//----      
double UpperBuffer[],MiddleBuffer[],LowerBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(ExtWPRPeriod);
//----      
   string shortname;
   StringConcatenate(shortname,"WPR3(",ExtWPRPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----      
   SetIndexBuffer(0,UpperBuffer,INDICATOR_DATA);
//----    1    AroonShift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(UpperBuffer,true);
//----      
   SetIndexBuffer(1,MiddleBuffer,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(MiddleBuffer,true);
//----      
   SetIndexBuffer(2,LowerBuffer,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       3
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(LowerBuffer,true);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----    
   int limit,bar;
   double range,HH,LL;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      MiddleBuffer[bar]=UpperBuffer[bar]=LowerBuffer[bar]=50;
      HH=high[ArrayMaximum(high,bar,ExtWPRPeriod)];
      LL=low[ArrayMinimum(low,bar,ExtWPRPeriod)];
      range=HH-LL;
      //----
      if(!CompareDouble(range,0.0))
        {
         MiddleBuffer[bar]=-100*(HH-close[bar])/range;
         UpperBuffer[bar]=-100*(HH-high[bar])/range;
         LowerBuffer[bar]=-100*(HH-low[bar])/range;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                             |
//+------------------------------------------------------------------+
bool CompareDouble(double Number1,double Number2)
  {
//----
   bool Compare=NormalizeDouble(Number1-Number2,8)==0;
//----
   return(Compare);
  }
//+------------------------------------------------------------------+
