//+------------------------------------------------------------------+
//|                                            DynamicRS_3CLines.mq5 |
//|                           Copyright  2006, Renato P. dos Santos |
//|                   inspired on 4xtraderCY's and SchaunRSA's ideas |
//|   http://www.strategybuilderfx.com/forums/showthread.php?t=16086 |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Renato P. dos Santos"
#property link "http://www.strategybuilderfx.com/forums/showthread.php?t=16086"
//----   
#property version   "1.00"
//----  
#property description ""
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 3
//----    
#property indicator_plots   3
//+----------------------------------------------+
//|     1          |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----       DarkOrange 
#property indicator_color1  clrDarkOrange
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    2  2
#property indicator_width1  2
//----   
#property indicator_label1  "Top"
//+----------------------------------------------+
//|    2                  |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----       Lime 
#property indicator_color2  clrLime
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "Bottom"
//+----------------------------------------------+
//|    3                  |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----       MediumPurple 
#property indicator_color3  clrMediumPurple
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  2
#property indicator_width3  2
//----   
#property indicator_label3  "ExtMap"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int    Shift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double Ind1Buffer[];
double Ind2Buffer[];
double Ind3Buffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_total=2;
//----      
   SetIndexBuffer(0,Ind1Buffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(Ind1Buffer,true);
//----      
   SetIndexBuffer(1,Ind3Buffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(Ind3Buffer,true);
//----      
   SetIndexBuffer(2,Ind2Buffer,INDICATOR_DATA);
//----    3    Shift
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       3  min_rates_total
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(Ind2Buffer,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"DynamicRS_3CLines");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----    
   int limit,bar;
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_total; //      
      bar=limit+1;
      double res=(high[bar]+low[bar])/2;
      Ind1Buffer[bar]=res;
      Ind2Buffer[bar]=res;
      Ind3Buffer[bar]=res;
     }
   else limit=rates_total-prev_calculated; //      
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      Ind1Buffer[bar]=Ind1Buffer[bar+1];
      Ind2Buffer[bar]=Ind2Buffer[bar+1];
      Ind3Buffer[bar]=Ind3Buffer[bar+1];
      //----
      if(high[bar]<high[bar+1] && high[bar]<Ind2Buffer[bar+1])
        {
         Ind2Buffer[bar]=high[bar];
         Ind3Buffer[bar]=high[bar];
         Ind1Buffer[bar]=Ind1Buffer[bar+1];
        }
      else if(low[bar]>low[bar+1] && low[bar]>Ind2Buffer[bar+1])
        {
         Ind2Buffer[bar]=low[bar];
         Ind1Buffer[bar]=low[bar];
         Ind3Buffer[bar]=Ind3Buffer[bar+1];
        }
      else
        {
         Ind2Buffer[bar]=Ind2Buffer[bar+1];
         if(Ind2Buffer[bar+1]==Ind1Buffer[bar+1])
           {
            Ind1Buffer[bar]=Ind2Buffer[bar+1];
            Ind3Buffer[bar]=Ind3Buffer[bar+1];
           }
         else if(Ind2Buffer[bar+1]==Ind3Buffer[bar+1])
           {
            Ind3Buffer[bar]=Ind2Buffer[bar+1];
            Ind1Buffer[bar]=Ind1Buffer[bar+1];
           }
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
