//+------------------------------------------------------------------+
//|                                               ChanellOnParabolic |
//|                                      Copyright  2009, Svinozavr |
//|                                                                  |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2009, Svinozavr"
//----    
#property link      ""
//----   
#property version   "1.01"
#property description ",   "
//+----------------------------------------------+ 
//|                  |
//+----------------------------------------------+ 
//----     
#property indicator_chart_window 
//----       3 
#property indicator_buffers 3
//----     
#property indicator_plots   3
//----     
#property indicator_type1   DRAW_ARROW
//----   
#property indicator_label1  " Parabolic Sar"
//----     
#property indicator_color1 clrDodgerBlue
//----    1
#property indicator_width1  1
//----     
#property indicator_type2   DRAW_LINE
//----   
#property indicator_label2  "Chanell On Parabolic Upper"
//----      
#property indicator_color2 clrRed
//----   - 
#property indicator_style2  STYLE_SOLID
//----     2
#property indicator_width2  2
//----     
#property indicator_type3   DRAW_LINE
//----   
#property indicator_label3  "Chanell On Parabolic Lower"
//----      
#property indicator_color3 clrMediumSeaGreen
//----   - 
#property indicator_style3  STYLE_SOLID
//----     2
#property indicator_width3  2
//+----------------------------------------------+ 
//|                            |
//+----------------------------------------------+ 
#define RESET 0 //        
//+----------------------------------------------+ 
//|                    |
//+----------------------------------------------+ 
input double Step=0.02; //SAR 
input double Maximum=0.2; //SAR 
input int Wide=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double LowestBuffer[];
double HighestBuffer[];
double SarBuffer[];
//----
double wide;
//----      
int min_rates_total;
//----      
int SAR_Handle;
//+------------------------------------------------------------------+ 
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=1;
   wide=Wide*_Point;
//----    SAR
   SAR_Handle=iSAR(NULL,0,Step,Maximum);
   if(SAR_Handle==INVALID_HANDLE)Print("      SAR");
//----      
   SetIndexBuffer(0,SarBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,LowestBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,HighestBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
//----          
   ArraySetAsSeries(LowestBuffer,true);
   ArraySetAsSeries(HighestBuffer,true);
   ArraySetAsSeries(SarBuffer,true);
//----  ,    
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string shortname;
   StringConcatenate(shortname,"Chanell On Parabolic Sar(",DoubleToString(Step,2),", ",DoubleToString(Maximum,2),", ",Wide,")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(SAR_Handle)<rates_total || rates_total<min_rates_total)return(RESET);
//----    
   int limit,to_copy,bar;
   double middleprice0,middleprice1,top,bot;
   static double prev_top,prev_bot;
//----    limit        
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_total; //      
      to_copy=limit+2;
     }
   else
     {
      limit=rates_total-prev_calculated; //      
      to_copy=limit+1;
     }
//----        
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//----   
   top=prev_top;
   bot=prev_bot;
//----      
   if(CopyBuffer(SAR_Handle,0,0,to_copy,SarBuffer)<=0) return(RESET);
//----     
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      middleprice0=(high[bar]+low[bar])/2; //     
      middleprice1=(high[bar+1]+low[bar+1])/2; //     
      //----
      if(SarBuffer[bar+1]>=middleprice1 && SarBuffer[bar]<middleprice0) //  
         if(top-SarBuffer[bar]>wide) bot=SarBuffer[bar];
      //----
      if(SarBuffer[bar+1]<=middleprice1 && SarBuffer[bar]>middleprice0) //  
         if(SarBuffer[bar]-bot>wide) top=SarBuffer[bar];
      //----
      HighestBuffer[bar]=top;
      LowestBuffer[bar]=bot;
      //----        
      if(bar)
        {
         prev_top=top;
         prev_bot=bot;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
