//+------------------------------------------------------------------+ 
//|                                             Laguerre_ADX_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.00"
//----     
#property indicator_separate_window 
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                      //        
#define INDICATOR_NAME "Laguerre_ADX"                //    
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---      
#property indicator_type1   DRAW_FILLING
//---     
#property indicator_color1 clrDodgerBlue,clrDeepPink
//---    
#property indicator_label1  INDICATOR_NAME
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level2 0.75
#property indicator_level3 0.45
#property indicator_level4 0.15
//----         
#property indicator_levelcolor clrMagenta
//----       -
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;         //  
input uint ADXPeriod=14;
input double gamma=0.764;
input int Shift=0;                                 //       
//+----------------------------------------------+
//---   ,   
//---      
double UpIndBuffer[];
double DnIndBuffer[];
//---   
string Symbol_,Word;
//---      
int min_rates_total;
//---      
int Ind_HandleP,Ind_HandleM;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("          ");
      return(INIT_FAILED);
     }
//---   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//---    Laguerre_PlusDi
   Ind_HandleP=iCustom(Symbol_,TimeFrame,"Laguerre_PlusDi",ADXPeriod,gamma);
   if(Ind_HandleP==INVALID_HANDLE)
     {
      Print("      Laguerre_PlusDi");
      return(INIT_FAILED);
     }
//---    Laguerre_MinusDi
   Ind_HandleM=iCustom(Symbol_,TimeFrame,"Laguerre_MinusDi",ADXPeriod,gamma);
   if(Ind_HandleM==INVALID_HANDLE)
     {
      Print("      Laguerre_MinusDi");
      return(INIT_FAILED);
     }
//---   
   IndInit(0,UpIndBuffer,INDICATOR_DATA);
   IndInit(1,DnIndBuffer,INDICATOR_DATA);
//---  
   PlotInit(0,0.0,0,Shift);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,2);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],ENUM_INDEXBUFFER_TYPE Type)
  {
//---      
   SetIndexBuffer(Number,Buffer,Type);
//---       
   ArraySetAsSeries(Buffer,true);
//---
  }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+    
void PlotInit(int Number,double Empty_Value,int Draw_Begin,int nShift)
  {
//---      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//---       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//---
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_HandleP)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
   if(BarsCalculated(Ind_HandleM)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---    
   if(!CountIndicator(0,NULL,TimeFrame,Ind_HandleP,0,UpIndBuffer,Ind_HandleM,0,DnIndBuffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//---
#define SIZE 1 //      CountLine
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      UpIndHandle,     //   
                    uint     UpBuffNumb,      //       
                    double&  UpIndBuf[],      //      
                    int      DnIndHandle,     //   
                    uint     DnBuffNumb,      //       
                    double&  DnIndBuf[],      //      
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);

      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double UpArr[1],DnArr[1];
         //---      
         if(CopyBuffer(UpIndHandle,UpBuffNumb,iTime[bar],1,UpArr)<=0) return(RESET);
         if(CopyBuffer(DnIndHandle,DnBuffNumb,iTime[bar],1,DnArr)<=0) return(RESET);
         
         UpIndBuf[bar]=UpArr[0]; 
         DnIndBuf[bar]=DnArr[0];
         //---     
         if(MathAbs(UpArr[0]-DnArr[0])<0.01)
           {
            if(UpIndBuf[bar+1]>DnIndBuf[bar+1]) UpIndBuf[bar]+=0.05;
            if(UpIndBuf[bar+1]<DnIndBuf[bar+1]) DnIndBuf[bar]+=0.05;
           }
        }
      else
        {
         UpIndBuf[bar]=UpIndBuf[bar+1];
         DnIndBuf[bar]=DnIndBuf[bar+1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
