//+------------------------------------------------------------------+ 
//|                                                  LeManChanel.mq5 | 
//|                                         Copyright  2009, LeMan. |
//|                                                 b-market@mail.ru |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2009, LeMan."
//----    
#property link      "b-market@mail.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 2 
//----    
#property indicator_plots   2
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "Upper LeMan"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----       Magenta 
#property indicator_color2 clrMagenta
//----   -  
#property indicator_style2  STYLE_SOLID
//----     1
#property indicator_width2  1
//----   
#property indicator_label2  "Lower LeMan"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint period=12;
input int Shift=1; //      
//+-----------------------------------+
//----   ,    
//----      
double UpperBuffer[];
double LowerBuffer[];
//----   ,    
//----      
int Count[];
double HC[],CL[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)    //     
  {
//----
   int numb,Max1,Max2;
   static int count=1;
//----
   Max2=Size;
   Max1=Max2-1;
//----
   count--;
   if(count<0) count=Max1;
//----
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+    
//| Indicator initialization function                                |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----  
   min_rates_total=int(period+1);
//----       
   ArrayResize(Count,period);
   ArrayResize(HC,period);
   ArrayResize(CL,period);
//----         
   ArraySetAsSeries(HC,true);
   ArraySetAsSeries(CL,true);
//----      
   SetIndexBuffer(0,UpperBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(UpperBuffer,true);
//----      
   SetIndexBuffer(1,LowerBuffer,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(LowerBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"LeManChanel(",period,",",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| Indicator iteration function                                     |
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----        
   int limit,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-2; //    
   else limit=rates_total-prev_calculated; //      
//----         
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      HC[Count[0]]=high[bar]-close[bar+1];
      CL[Count[0]]=close[bar+1]-low[bar];
      //----
      UpperBuffer[bar]=close[bar]+HC[ArrayMaximum(HC,0,period)];
      LowerBuffer[bar]=close[bar]-CL[ArrayMaximum(CL,0,period)];
      //----      
      if(bar>0) Recount_ArrayZeroPos(Count,period);
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
