//+------------------------------------------------------------------+
//|                                SlopeDirectionLine_HTF_Signal.mq5 |
//|                               Copyright  2015, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru |
//+------------------------------------------------------------------+
//|     SmoothAlgorithms.mqh                  |
//|    : __\MQL5\Include  |
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---   
#property version   "1.60"
//+----------------------------------------------+ 
//|                  |
//+----------------------------------------------+ 
//---     
#property indicator_chart_window 
#property indicator_buffers 1
#property indicator_plots   1
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET  0 //        
//+-----------------------------------+    
//|          |
//+-----------------------------------+    
#include <SmoothAlgorithms.mqh>
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum APPLIED_PRICE //  
  {
   PRICE_CLOSE_ = 1,     // Close
   PRICE_OPEN_,          // Open
   PRICE_HIGH_,          // High
   PRICE_LOW_,           // Low
   PRICE_MEDIAN_,        // Median Price (HL/2)
   PRICE_TYPICAL_,       // Typical Price (HLC/3)
   PRICE_WEIGHTED_,      // Weighted Close (HLCC/4)
   PRICE_SIMPLE,         // Simple Price (OC/2)
   PRICE_QUARTER_,       // Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  // TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input string Symbol_="";                   //  
input ENUM_TIMEFRAMES Timeframe=PERIOD_H6; //     
input Smooth_Method MA_Method1=MODE_LWMA;  //   
input uint Length1=12; //   
input int Phase1=15;   //   
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method2=MODE_SMA; //    
input int Phase2=15;  //   
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input APPLIED_PRICE IPC=PRICE_CLOSE;// 
input bool On_Push = false;                           //    push-
input bool On_Email = false;                          //    
input bool On_Alert = true;                           //    
input bool On_Play_Sound = false;                     //     
input string NameFileSound = "expert.wav";            //     
input string  CommentSirName="SlopeDirectionLine: ";  //   -
input uint SignalBar=1;                               //    
//---   
input string Symbols_Sirname="SlopeDirectionLine_Label_"; //    
input color UpSymbol_Color=clrBlue;        //   
input color DnSymbol_Color=clrRed;         //   
input color IndName_Color=clrDarkOrchid;   //   
input uint Symbols_Size=34;                //   
input uint Font_Size=15;                   //    
input int X_3=120;                         //    
input int Y_3=10;                          //    
input bool ShowIndName=true;               //   
input ENUM_BASE_CORNER  WhatCorner=CORNER_RIGHT_UPPER; //  
input uint X_=0;                           //   
input uint Y_=0;                           //   
//+-----------------------------------+
//---      
int SlopeDirectionLine_Handle;
//---      
int min_rates_total;
//---         
uint X_0,X_1,X_2,X_3_,Yn,Y_3_;
//---     
string name0,name1,name2,name3,IndName,Symb;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {
//---
   return(StringSubstr(EnumToString(timeframe),7,-1));
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
void CreateTLabel(long   chart_id,         //  
                  string name,             //  
                  int    nwin,             //  
                  ENUM_BASE_CORNER corner, //   
                  ENUM_ANCHOR_POINT point, //   
                  int    X,                //      X   
                  int    Y,                //      Y   
                  string text,             // 
                  color  Color,            //  
                  string Font,             //  
                  int    Size)             //  
  {
//---
   ObjectCreate(chart_id,name,OBJ_LABEL,0,0,0);
   ObjectSetInteger(chart_id,name,OBJPROP_CORNER,corner);
   ObjectSetInteger(chart_id,name,OBJPROP_ANCHOR,point);
   ObjectSetInteger(chart_id,name,OBJPROP_XDISTANCE,X);
   ObjectSetInteger(chart_id,name,OBJPROP_YDISTANCE,Y);
   ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetString(chart_id,name,OBJPROP_FONT,Font);
   ObjectSetInteger(chart_id,name,OBJPROP_FONTSIZE,Size);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
  }
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
void SetTLabel(long   chart_id,         //  
               string name,             //  
               int    nwin,             //  
               ENUM_BASE_CORNER corner, //   
               ENUM_ANCHOR_POINT point, //   
               int    X,                //      X   
               int    Y,                //      Y   
               string text,             // 
               color  Color,            //  
               string Font,             //  
               int    Size)             //  
  {
//---
   if(ObjectFind(chart_id,name)==-1) CreateTLabel(chart_id,name,nwin,corner,point,X,Y,text,Color,Font,Size);
   else
     {
      ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
      ObjectSetInteger(chart_id,name,OBJPROP_XDISTANCE,X);
      ObjectSetInteger(chart_id,name,OBJPROP_YDISTANCE,Y);
      ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
      ObjectSetInteger(chart_id,name,OBJPROP_FONTSIZE,Size);
     }
  }
//+------------------------------------------------------------------+    
//| SlopeDirectionLine indicator initialization function             | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//---    CXMA   SmoothAlgorithms.mqh
   CXMA XMA;
//---     
   int LengthR=int(MathMax(MathSqrt(Length1),1));
   min_rates_total=GetStartBars(MA_Method1,Length1,Phase1);
   min_rates_total+=int(GetStartBars(MA_Method2,LengthR,Phase2)+4+SignalBar);
//---  
   if(Symbol_!="") Symb=Symbol_;
   else Symb=Symbol();
//---
   X_0=X_;
   X_1=uint(X_0+Symbols_Size*1.1);
   X_2=uint(X_1+Symbols_Size*1.1);
   Yn=Y_+5;
//---
   name0=Symbols_Sirname+"0";
   name1=Symbols_Sirname+"1";
   name2=Symbols_Sirname+"2";
   if(ShowIndName)
     {
      Y_3_=Yn+Y_3;
      X_3_=X_0+X_3;
      name3=Symbols_Sirname+"3";
      StringConcatenate(IndName,"SlopeDirectionLine(",Symb," ",GetStringTimeframe(Timeframe),")");
     }
//---    SlopeDirectionLine
   SlopeDirectionLine_Handle=iCustom(Symb,Timeframe,"SlopeDirectionLine",MA_Method1,Length1,Phase1,MA_Method2,Phase2,IPC,0,0,On_Push,On_Email,On_Alert,On_Play_Sound,NameFileSound,CommentSirName,SignalBar);
   if(SlopeDirectionLine_Handle==INVALID_HANDLE) Print("      SlopeDirectionLine");
//---      
   string shortname;
   string Smooth1=XMA.GetString_MA_Method(MA_Method1);
   string Smooth2=XMA.GetString_MA_Method(MA_Method2);
   StringConcatenate(shortname,"SlopeDirectionLine(",Length1,", ",Smooth1,", ",Smooth2,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---  
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void Deinit()
  {
//---
   if(ObjectFind(0,name0)!=-1) ObjectDelete(0,name0);
   if(ObjectFind(0,name1)!=-1) ObjectDelete(0,name1);
   if(ObjectFind(0,name2)!=-1) ObjectDelete(0,name2);
   if(ObjectFind(0,name3)!=-1) ObjectDelete(0,name3);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//---
   Deinit();
//---
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+  
//| SlopeDirectionLine iteration function                            | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(SlopeDirectionLine_Handle)<min_rates_total) return(RESET);
   if(BarsCalculated(SlopeDirectionLine_Handle)<Bars(Symb,Timeframe)) return(prev_calculated);
//---   
   int to_copy=4;
   double dind0,dind1,dind2;
   double SlopeDirectionLine[4];
   color Color0,Color1,Color2;
//---      
   if(CopyBuffer(SlopeDirectionLine_Handle,0,SignalBar,to_copy,SlopeDirectionLine)<=0) return(RESET);
//---
   dind0=SlopeDirectionLine[3]-SlopeDirectionLine[2];
   dind1=SlopeDirectionLine[2]-SlopeDirectionLine[1];
   dind2=SlopeDirectionLine[1]-SlopeDirectionLine[0];
//---
   if(dind0<0) Color0=DnSymbol_Color; else Color0=UpSymbol_Color;
   if(dind1<0) Color1=DnSymbol_Color; else Color1=UpSymbol_Color;
   if(dind2<0) Color2=DnSymbol_Color; else Color2=UpSymbol_Color;
//---
   SetTLabel(0,name0,0,WhatCorner,ENUM_ANCHOR_POINT(2*WhatCorner),X_0,Yn,"t",Color0,"Wingdings 2",Symbols_Size);
   SetTLabel(0,name1,0,WhatCorner,ENUM_ANCHOR_POINT(2*WhatCorner),X_1,Yn,"u",Color1,"Wingdings 2",Symbols_Size);
   SetTLabel(0,name2,0,WhatCorner,ENUM_ANCHOR_POINT(2*WhatCorner),X_2,Yn,"v",Color2,"Wingdings 2",Symbols_Size);
   if(ShowIndName) SetTLabel(0,name3,0,WhatCorner,ENUM_ANCHOR_POINT(2*WhatCorner),X_3_,Y_3_,IndName,IndName_Color,"Georgia",Font_Size);
//---
   ChartRedraw(0);
   return(rates_total);
  }
//+------------------------------------------------------------------+
