#property copyright "Scriptong"
#property link      "http://advancetools.net"
#property description "English: Record a tick stream to a file and the formation of non-standard timeframes.\nDescription available online AdvanceTools.net in the \"Tick volume - Collector ticks.\"\n\nRussian:         .\n    AdvanceTools.net   \"  -  .\""
#property version "1.02"


#property strict

#property indicator_separate_window
#property indicator_buffers 2 
#property indicator_color1 clrTurquoise
#property indicator_color2 clrRed

#include <TicksCollector_Classes_AD.mqh>

#define MAX_VIRTUAL_TICKS 1000000                                                                  //    ,    

struct NonStandartWindow                                                                           //    
{
   int hWindow;                                                                                    //  
   int hFile;                                                                                      //   
   datetime lastBar;                                                                               //      
};

enum ENUM_YESNO
{
    YES,                                                                                           // Yes / 
    NO                                                                                             // No / 
};


//   

input string     i_string1                      = "The ticks collecting params /   ";// =========================
input ENUM_YESNO i_collectTicks                 = YES;                                             // Use ticks collecting? /   ?
input ENUM_YESNO i_setUserFileName              = NO;                                              // Set the custom file name? /     ?
input string     i_userFileName                 = "user.tks";                                      // Name of ticks file /   
input ENUM_YESNO i_useForcedUpdate              = YES;                                             // Use file flush? /     ?
input int        i_everyNTicks                  = 10;                                              // File flush every N ticks /    N 
input int        i_maxShowTicksCount            = 1000;                                            // Maximal showing ticks /   

input string     i_string2                      = "Equal time chart /  ";      // =========================
input ENUM_YESNO i_convertToTime                = NO;                                              // Create the chart? /  ?
input int        i_secondsPerBar                = 30;                                              // Period in seconds /   
input int        i_resultTimeTFInMinutes        = 312;                                             // Name of TF in minutes /    
input ENUM_BID_ASK_TYPE i_timeBidAskType        = BID_ASK_TYPE_ONLY_BID;                           // Price type /   

input string     i_string3                      = "Chart of Range-bar /  Range-";       // =========================
input ENUM_YESNO i_convertToPoints              = NO;                                              // Create the chart? /  ?
input int        i_pointsPerBar                 = 10;                                              // Points per one bar /    
input int        i_resultPointsTFInMinutes      = 313;                                             // Name of TF in minutes /    
input ENUM_BID_ASK_TYPE i_pointBidAskType       = BID_ASK_TYPE_ONLY_BID;                           //    

input string     i_string4                      = "Equal volume chart /   ";// =========================
input ENUM_YESNO i_convertToTicksVolume         = NO;                                              // Create the chart? /  ?
input int        i_ticksPerBar                  = 10;                                              // Ticks per one bar /    
input int        i_resultTicksTFInMinutes       = 314;                                             // Name of TF in minutes /    
input ENUM_BID_ASK_TYPE i_volumeBidAskType      = BID_ASK_TYPE_ONLY_BID;                           // Price type /   


bool g_activate;

int g_mt4Message,                                                                                  //   4
    g_newTicksCnt,                                                                                 //   ,      
    g_everyNTicks,                                                                                 //     ,   
    g_ticksCnt;                                                                                    //    
    
TickStruct g_nonWritedTicks[];                                                                     //  ,      
    

NonStandartTFChart g_chartTime(i_convertToTime == YES, i_resultTimeTFInMinutes, i_secondsPerBar, CONVERT_TYPE_TF, i_timeBidAskType, _Digits, _Point, _Symbol),
                   g_chartPoint(i_convertToPoints == YES, i_resultPointsTFInMinutes, i_pointsPerBar, CONVERT_TYPE_POINT, i_pointBidAskType, _Digits, _Point, _Symbol),                                                                   
                   g_chartTick(i_convertToTicksVolume == YES, i_resultTicksTFInMinutes, i_ticksPerBar, CONVERT_TYPE_VOLUME, i_volumeBidAskType, _Digits, _Point, _Symbol);                                                                    

//   
double g_bid[];
double g_ask[];

//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//| Custom indicator initialization function                                                                                                                                                          |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
int OnInit()
{
   g_activate = false;
   
   if (!TuningParameters())                                                                        //     
      return INIT_FAILED; 
      
   if (!IsTicksBufferReady())                                                                      //   
      return INIT_FAILED;                                

   if (!BuffersBind())                                                                             //     
      return INIT_FAILED;       
      
   if (!IsFilesReady())
      return INIT_FAILED;                        
                                                   
   g_activate = true;
   return INIT_SUCCEEDED;
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                          |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool TuningParameters()
{
   string name = WindowExpertName();
   bool isRussian = TerminalInfoString(TERMINAL_LANGUAGE) == "Russian";
   

   if (i_maxShowTicksCount < 2)
   {
      if (isRussian)
         Alert(name, ":         2.  .");
      else
         Alert(name, ": the maximal amount of showing ticks could not be less than 2. Indicator is off.");
      return false;
   } 
   
   if (i_maxShowTicksCount > Bars)
   {
      if (isRussian)
         Alert(name, ":         ", Bars,".  .");
      else
         Alert(name, ": the maximal amount of showing ticks could not be more than ", Bars, ". Indicator is off.");
      return false;
   } 

   g_everyNTicks = i_everyNTicks;
   if (i_useForcedUpdate == NO)
      g_everyNTicks = MAX_VIRTUAL_TICKS;
   
   if (i_useForcedUpdate == YES && i_everyNTicks < 1)
   {
      if (isRussian)
         Alert(name, ":  ,        ,    .  .");
      else
         Alert(name, ": the value of parameter \"File flush every N ticks\" could not be less than 1. Indicator is off.");
      
      return false;
   } 

   ENUM_YESNO convertToTime = i_convertToTime;
   ENUM_YESNO convertToPoints = i_convertToPoints;
   ENUM_YESNO convertToTicksVolume = i_convertToTicksVolume;
   if (!IsDllsAllowed() && (i_convertToTime == YES || i_convertToPoints == YES || i_convertToTicksVolume == YES))
   {
      if (isRussian)
         Alert(name, ":        DLL .   .");
      else
         Alert(name, ": the DLL import should be allowed if updating of non-standard timeframes needed.");
      
      convertToTime = NO;
      convertToPoints = NO;
      convertToTicksVolume = NO;
   }

   if (!IsThreeParametersCorrect(convertToTime, i_secondsPerBar,  i_resultTimeTFInMinutes, "Period in seconds /   ", "Name of TF in minutes /    ")) 
      return false;
      
   if (!IsThreeParametersCorrect(convertToPoints, i_pointsPerBar, i_resultPointsTFInMinutes, "Points per one bar /    ", "Name of TF in minutes /    ")) 
      return false;

   if (!IsThreeParametersCorrect(convertToTicksVolume, i_ticksPerBar, i_resultTicksTFInMinutes, "Ticks per one bar /    ", "Name of TF in minutes /    ")) 
      return false;

   return true;
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|      ,                                                                                     |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsThreeParametersCorrect(bool isConvert, int param, int tf, string paramName, string tfName)
{
   if (!isConvert)
      return (true);
      
   string name = WindowExpertName();
      
   if (param < 1)
   {
      if (TerminalInfoString(TERMINAL_LANGUAGE) == "Russian")
         Alert(name, ":   ", paramName, "    .  .");
      else
         Alert(name, ": the value of parameter ", paramName," could be the natural number. Indicator is off.");
      return false;
   }

   if (IsTFCorrect(tf))
   {
      if (TerminalInfoString(TERMINAL_LANGUAGE) == "Russian")
         Alert(name, ":   ", tfName, "      .  .");
      else
         Alert(name, ": the value of parameter ", tfName," could not be specified the standard timeframe. Indicator is off.");
      return false;
   }
   
   return true;
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                 |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsTFCorrect(int tf)
{
   return (tf == PERIOD_M1  || tf == PERIOD_M5 || tf == PERIOD_M15 || 
           tf == PERIOD_M30 || tf == PERIOD_H1 || tf == PERIOD_H4  ||
           tf == PERIOD_D1  || tf == PERIOD_W1 || tf == PERIOD_MN1);
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                           |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsTicksBufferReady()
{
   g_ticksCnt = 0;
   g_newTicksCnt = 0;
        
   if (ArrayResize(g_nonWritedTicks, g_everyNTicks) != g_everyNTicks)
   {
      if (TerminalInfoString(TERMINAL_LANGUAGE) == "Russian")
         Alert(WindowExpertName(), ":       .  .");
      else
         Alert(WindowExpertName(), ": unable to allocate memory for ticks buffer. Indicator is off.");
      return false;
   }
   
   return true;
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//| Custom indicator deinitialization function                                                                                                                                                        |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void OnDeinit(const int reason)
{
   IsFileFlush(true);

   g_chartPoint.CloseFile();
   g_chartTime.CloseFile();
   g_chartTick.CloseFile();
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                              |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool BuffersBind()
{
   string name = WindowExpertName();
   
   //     
   if (!SetIndexBuffer(0, g_bid) ||
       !SetIndexBuffer(1, g_ask))
   {
      int error = GetLastError();
      if (TerminalInfoString(TERMINAL_LANGUAGE) == "Russian")
         Alert(name, ":      .  ", error);
      else
         Alert(name, ": unable to bind the arrays to the indicator buffers. Indicator is off. Error N", error);
      
      return false;
   }

   //    
   for (int i = 0; i < 2; i++)
      SetIndexStyle(i, DRAW_LINE);
   
   SetIndexLabel(0, "Bid");
   SetIndexLabel(1, "Ask");
   return true;
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                        |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsTicksFileOpen(int &hTicksFile)
{
   string fileName = GetTicksFileName();
   hTicksFile = FileOpen(fileName, FILE_BIN | FILE_READ | FILE_WRITE | FILE_SHARE_READ | FILE_SHARE_WRITE);
   if (hTicksFile >= 0)
      return true;

   if (TerminalInfoString(TERMINAL_LANGUAGE) == "Russian")
      Alert(WindowExpertName(), ":     ", fileName, ".  .");
   else
      Alert(WindowExpertName(), ": unable to open the file ", fileName, ". Indicator is off.");
   return false;
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                          |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsFilesReady()
{
   //   
   return g_chartPoint.CreateHistoryFile() && 
          g_chartTime.CreateHistoryFile() && 
          g_chartTick.CreateHistoryFile();
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|   ,                                                                                                                                        |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
string GetTicksFileName()
{
   if (i_setUserFileName == YES)
      return (i_userFileName);
      
   return (Symbol() + ".tks");
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                               |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void ReadFile(bool fillOnlyBuffers)
{
   //  
   int hTicksFile = -1;
   if (!IsTicksFileOpen(hTicksFile))
      return;

   //    
   int recSize = sizeof(TickStruct);                                                               //  ,      
   ulong sizeInRec = FileSize(hTicksFile) / recSize;                                               //      (      )
   g_ticksCnt = (int)MathMin(i_maxShowTicksCount, sizeInRec);                                      //  ,      
   
   int cnt = g_ticksCnt - 1;                                                                       //   ,     
   ulong startRecNumber = sizeInRec - g_ticksCnt;                                                  //   (  ),        
   ulong currentRec = 0;                                                                           //   
   TickStruct tick;                                                                                //        
   
   while (currentRec < sizeInRec)
   {
      //   
      uint bytesCnt = FileReadStruct(hTicksFile, tick);
      if (bytesCnt != recSize)
      {
         int error = GetLastError();
         if (TerminalInfoString(TERMINAL_LANGUAGE) == "Russian")
            Alert(WindowExpertName(), ":     ", error);
         else
            Alert(WindowExpertName(), ": unable to read the source file. Error N", error);
         
         return;
      }

      //   
      if (currentRec >= startRecNumber)
         FillIndicatorBuffers(tick, cnt);
      currentRec++;   
         
      //    ,    
      if (fillOnlyBuffers)   
         continue;
         
      //    ,    
      bool isWrite = g_chartTime.ConvertData(tick, false) &&
                     g_chartPoint.ConvertData(tick, false) &&
                     g_chartTick.ConvertData(tick, false);
      if (!isWrite)
      {
         g_activate = false;
         return;
      }
   }

   //      
   FileClose(hTicksFile);
   g_chartTime.SetPointerToEndOfFile();
   g_chartPoint.SetPointerToEndOfFile();
   g_chartTick.SetPointerToEndOfFile();
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                        |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void FillIndicatorBuffers(TickStruct &tick, int& cnt)
{
   g_bid[cnt] = tick.bid;
   g_ask[cnt] = tick.ask; 
   cnt--;
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                      |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void MoveDataToTheLeft()
{
   for (int i = g_ticksCnt - 1; i > 0; i--)
   {
      g_bid[i] = g_bid[i - 1];
      g_ask[i] = g_ask[i - 1];
   }
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|    g_everyNTicks                                                                                                                                         |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsFileFlush(bool isDeinit)
{
   if (i_collectTicks == NO)
      return true;

   //    
   g_nonWritedTicks[g_newTicksCnt].time = TimeCurrent();
   g_nonWritedTicks[g_newTicksCnt].bid = Bid;
   g_nonWritedTicks[g_newTicksCnt].ask = Ask;
   g_newTicksCnt++;
   if (g_newTicksCnt < g_everyNTicks && !isDeinit)
      return true;
   
   //    
   int hTicksFile = -1;
   if (!IsTicksFileOpen(hTicksFile))
      return false;
     
   FileSeek(hTicksFile, 0, SEEK_END);
   for (int i = 0; i < g_newTicksCnt; i++)
   {
      if (FileWriteStruct(hTicksFile, g_nonWritedTicks[i]) == sizeof(TickStruct))
         continue;
         
      int error = GetLastError();
      if (TerminalInfoString(TERMINAL_LANGUAGE) == "Russian")
         Alert(WindowExpertName(), ":      ", error, ".  .");
      else
         Alert(WindowExpertName(), ": uunable to save the data to file. Error N", error, ". Indicator is off.");
      
      return false;
   }
   
   //        
   FileClose(hTicksFile);
   g_newTicksCnt = 0;

   return true;
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|      ,                                                                                                                                    |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool SaveRegularTick()
{
   TickStruct tick(TimeCurrent(), Bid, Ask);

   //   
   bool isWrite = g_chartTime.ConvertData(tick, true) &&
                  g_chartPoint.ConvertData(tick, true) &&
                  g_chartTick.ConvertData(tick, true);
   if (!isWrite)
      return false;

   g_chartTime.UpdateChart();
   g_chartPoint.UpdateChart();
   g_chartTick.UpdateChart();
   
   //     
   g_bid[0] = Bid;
   g_ask[0] = Ask;
   
   return IsFileFlush(false);
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                           |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool CalcIndicatorData()
{
   static datetime lastBarTime = 0;
   
   if (g_ticksCnt < i_maxShowTicksCount)
      g_ticksCnt++;

   if (lastBarTime == Time[0])
      MoveDataToTheLeft();
   else
      lastBarTime = Time[0];
   
   return SaveRegularTick();
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//| Custom indicator iteration function                                                                                                                                                               |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime& time[],
                const double& open[],
                const double& high[],
                const double& low[],
                const double& close[],
                const long& tick_volume[],
                const long& volume[],
                const int& spread[])
{
   if (!g_activate)
      return rates_total;

   //   
   if (g_ticksCnt == 0)
   {
      ReadFile(false);
      if (g_ticksCnt > 0)
         return rates_total;
   }
 
   //         
   if (!CalcIndicatorData())
      g_activate = false;

   return rates_total;
}
