//+------------------------------------------------------------------+ 
//|                                                  iBBFill_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.60"
#property description "iBBFill       "
//---     
#property indicator_chart_window
//---    10
#property indicator_buffers 10
//---    
#property indicator_plots  6
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                   //        
#define INDICATOR_NAME "iBBFill"  //    
#define SIZECL 3                  //      CountCloudIndicator  
#define SIZEL 3                   //      CountLineIndicator  
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//---      
#property indicator_type1   DRAW_FILLING
//---     
#property indicator_color1  C'10,10,70'
//---   
#property indicator_label1  "UpTrend"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//---      
#property indicator_type2   DRAW_FILLING
//---     
#property indicator_color2  C'70,10,10'
//---   
#property indicator_label2  "DnTrend"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//---      
#property indicator_type3   DRAW_FILLING
//---     
#property indicator_color3  C'50,50,50'
//---   
#property indicator_label3  "Flat"
//+----------------------------------------------+
//|    4             |
//+----------------------------------------------+
#property indicator_type4   DRAW_LINE
//----       Yellow 
#property indicator_color4 clrYellow
//----   -  
#property indicator_style4  STYLE_SOLID
//----     2
#property indicator_width4  2
//----   
#property indicator_label4  "BB MA"
//+----------------------------------------------+
//|    5             |
//+----------------------------------------------+
#property indicator_type5   DRAW_LINE
//----       DodgerBlue 
#property indicator_color5 clrDodgerBlue
//----   -  
#property indicator_style5  STYLE_SOLID
//----     2
#property indicator_width5  2
//----   
#property indicator_label5  "BB Upper"
//+----------------------------------------------+
//|    6             |
//+----------------------------------------------+
#property indicator_type6   DRAW_LINE
//----       Red
#property indicator_color6 clrRed
//----   -  
#property indicator_style6  STYLE_SOLID
//----     2
#property indicator_width6  2
//----   
#property indicator_label6  "BB Lower"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;       //    ()
input uint                 BBPeriod=20;          //  BB
input double              BBDeviation=2;         //  BB
input ENUM_APPLIED_PRICE  BBPrice=PRICE_CLOSE;   //  BB
input int Shift=0;                               //      
//+----------------------------------------------+
//---   ,   
//---      
double UpIndBuffer1[],DnIndBuffer1[];
double UpIndBuffer2[],DnIndBuffer2[];
double UpIndBuffer3[],DnIndBuffer3[];
double IndBuffer1[];
double IndBuffer2[];
double IndBuffer3[];
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//---   
   min_rates_total=2;
//---    iBBFill
   Ind_Handle=iCustom(Symbol(),TimeFrame,"iBBFill",BBPeriod,BBDeviation,BBPrice);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      iBBFill");
      return(INIT_FAILED);
     }
//---   
   IndInit(0,UpIndBuffer1,INDICATOR_DATA);
   IndInit(1,DnIndBuffer1,INDICATOR_DATA);
   IndInit(2,UpIndBuffer2,INDICATOR_DATA);
   IndInit(3,DnIndBuffer2,INDICATOR_DATA);
   IndInit(4,UpIndBuffer3,INDICATOR_DATA);
   IndInit(5,DnIndBuffer3,INDICATOR_DATA);
   IndInit(6,IndBuffer1,INDICATOR_DATA);
   IndInit(7,IndBuffer2,INDICATOR_DATA);
   IndInit(8,IndBuffer3,INDICATOR_DATA);
//---  
   for(int count=0; count<6; count++) PlotInit(count,0,Shift);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---
   if(!CountCloudIndicator(0,NULL,TimeFrame,Ind_Handle,0,UpIndBuffer1,1,DnIndBuffer1,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountCloudIndicator(1,NULL,TimeFrame,Ind_Handle,2,UpIndBuffer2,3,DnIndBuffer2,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountCloudIndicator(2,NULL,TimeFrame,Ind_Handle,4,UpIndBuffer3,5,DnIndBuffer3,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountLineIndicator(0,NULL,TimeFrame,Ind_Handle,6,IndBuffer1,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountLineIndicator(1,NULL,TimeFrame,Ind_Handle,7,IndBuffer2,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountLineIndicator(2,NULL,TimeFrame,Ind_Handle,8,IndBuffer3,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//---
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],ENUM_INDEXBUFFER_TYPE Type)
  {
//---      
   SetIndexBuffer(Number,Buffer,Type);
//---       
   ArraySetAsSeries(Buffer,true);
//---
  }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+    
void PlotInit(int Number,int Draw_Begin,int nShift)
  {
//---      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//---       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//---
  }
//+------------------------------------------------------------------+
//| CountCloudIndicator                                              |
//+------------------------------------------------------------------+
bool CountCloudIndicator(uint Numb,                //   CountCloudIndicator      (  - 0)
                         string   Symb,            //  
                         ENUM_TIMEFRAMES TFrame,   //  
                         int      IndHandle,       //   
                         uint     UpBuffNumb,      //       
                         double&  UpIndBuf[],      //      
                         uint     DnBuffNumb,      //       
                         double&  DnIndBuf[],      //      
                         const datetime& iTime[],  //  
                         const int Rates_Total,    //       
                         const int Prev_Calculated,//       
                         const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZECL];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double UpArr[1],DnArr[1];
         //---      
         if(CopyBuffer(IndHandle,UpBuffNumb,iTime[bar],1,UpArr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,DnBuffNumb,iTime[bar],1,DnArr)<=0) return(RESET);
         //---
         UpIndBuf[bar]=UpArr[0];
         DnIndBuf[bar]=DnArr[0];
        }
      else
        {
         UpIndBuf[bar]=UpIndBuf[bar+1];
         DnIndBuf[bar]=DnIndBuf[bar+1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| CountLineIndicator                                               |
//+------------------------------------------------------------------+
bool CountLineIndicator(uint Numb,                //   CountLineIndicator      (  - 0)
                        string   Symb,            //  
                        ENUM_TIMEFRAMES TFrame,   //  
                        int      IndHandle,       //   
                        uint     BuffNumb,        //    
                        double&  IndBuf[],        //   
                        const datetime& iTime[],  //  
                        const int Rates_Total,    //       
                        const int Prev_Calculated,//       
                        const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZEL];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //---      
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);
         //---
         IndBuf[bar]=Arr[0];
        }
      else
        {
         IndBuf[bar]=IndBuf[bar+1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //   ()
  {
//---     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
