//+------------------------------------------------------------------+ 
//|                                                 KalmanFilter.mq5 | 
//|                    MQL5 code: Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1 Orange,Turquoise
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "KalmanFilter"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
enum Signal_mode
  {
   Trend, // 
   Kalman // 
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input double K=1.0; //  
input Applied_price_ IPC=PRICE_WEIGHTED; //  
input Signal_mode Signal=Kalman; //    
input int Shift=0; //      
input int PriceShift=0; //      
//+-----------------------------------+
//----  
double IndBuffer[],ColorBuffer[];
//----
double dPriceShift,Sqrt100,K100;
//----      
int min_rates_total;
//+------------------------------------------------------------------+    
//| KalmanFilter indicator initialization function                   | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=2;
//----     
   Sqrt100=MathSqrt(K/100);
   K100=K/100.0;
//----    
   dPriceShift=_Point*PriceShift;
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,31);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
//----     ,     
   SetIndexBuffer(1,ColorBuffer,INDICATOR_COLOR_INDEX);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----
   string shortname;
   StringConcatenate(shortname,"KalmanFilter(",DoubleToString(K,2),")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| KalmanFilter iteration function                                  | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total)return(0);
//----   
   int first,bar;
   double Velocity,Distance,Error;
   static double Velocity_;
//----
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=1; //      
      //----  
      IndBuffer[first-1]=PriceSeries(IPC,first-1,open,low,high,close);
      Velocity_=0.0;
     }
   else first=prev_calculated-1; //      
//----   
   Velocity=Velocity_;
//----    
   for(bar=first; bar<rates_total; bar++)
     {
      //----        
      if(rates_total!=prev_calculated && bar==rates_total-1)
        {
         Velocity_=Velocity;
        }
      //----
      Distance=PriceSeries(IPC,bar,open,low,high,close)-IndBuffer[bar-1];
      Error=IndBuffer[bar-1]+Distance*Sqrt100;
      Velocity+=Distance*K100;
      IndBuffer[bar]=Error+Velocity+dPriceShift;
      //----
      if(Signal==Trend)
        {
         if(IndBuffer[bar-1]>IndBuffer[bar]) ColorBuffer[bar]=0;
         else ColorBuffer[bar]=1;
        }
      else
        {
         if(Velocity>0) ColorBuffer[bar]=1;
         else           ColorBuffer[bar]=0;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+   
//|                                 |
//+------------------------------------------------------------------+ 
double PriceSeries(uint applied_price,//  
                   uint   bar,        //            
                   const double &Open[],
                   const double &Low[],
                   const double &High[],
                   const double &Close[])
  {
//----
   switch(applied_price)
     {
      //----     ENUM_APPLIED_PRICE
      case  PRICE_CLOSE: return(Close[bar]);
      case  PRICE_OPEN: return(Open [bar]);
      case  PRICE_HIGH: return(High [bar]);
      case  PRICE_LOW: return(Low[bar]);
      case  PRICE_MEDIAN: return((High[bar]+Low[bar])/2.0);
      case  PRICE_TYPICAL: return((Close[bar]+High[bar]+Low[bar])/3.0);
      case  PRICE_WEIGHTED: return((2*Close[bar]+High[bar]+Low[bar])/4.0);
      //----                            
      case  8: return((Open[bar] + Close[bar])/2.0);
      case  9: return((Open[bar] + Close[bar] + High[bar] + Low[bar])/4.0);
      //----                                
      case 10:
        {
         if(Close[bar]>Open[bar])return(High[bar]);
         else
           {
            if(Close[bar]<Open[bar])
               return(Low[bar]);
            else return(Close[bar]);
           }
        }
      //----         
      case 11:
        {
         if(Close[bar]>Open[bar])return((High[bar]+Close[bar])/2.0);
         else
           {
            if(Close[bar]<Open[bar])
               return((Low[bar]+Close[bar])/2.0);
            else return(Close[bar]);
           }
         break;
        }
      //----
      default: return(Close[bar]);
     }
//----
//return(0);
  }
//+------------------------------------------------------------------+
