//+------------------------------------------------------------------+ 
//|                                           JS-Stoh-BB-RSI_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.00"
//----     
#property indicator_separate_window
//----    5
#property indicator_buffers 5 
//----   5  
#property indicator_plots   5
//+----------------------------------------------+
//|     1            |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1 clrBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "Stochastic"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----        
#property indicator_color2 clrTeal
//----   -  
#property indicator_style2  STYLE_SOLID
//----     1
#property indicator_width2  1
//----   
#property indicator_label2  "RSI"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//----     
#property indicator_type3   DRAW_LINE
//----       - 
#property indicator_color3 clrBlueViolet
//----   -  
#property indicator_style3  STYLE_SOLID
//----     2
#property indicator_width3  2
//----   
#property indicator_label3  "Stochastic Signal"
//+----------------------------------------------+
//|    BB     |
//+----------------------------------------------+
//----      
#property indicator_type4   DRAW_LINE
#property indicator_type5   DRAW_LINE
//----    
#property indicator_color4  clrRed
#property indicator_color5  clrRed
//----   -  
#property indicator_style4 STYLE_SOLID
#property indicator_style5 STYLE_SOLID
//----     1
#property indicator_width4  1
#property indicator_width5  1
//----    
#property indicator_label4  "+2Sigma Stochastic"
#property indicator_label5  "-2Sigma Stochastic"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1  80.0
#property indicator_level2  70.0
#property indicator_level3  50.0
#property indicator_level4  30.0
#property indicator_level5  20.0
#property indicator_levelcolor clrMagenta
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                   //        
#define INDICATOR_NAME "JS-Stoh-BB-RSI_HTF"       //    
#define SIZE 5                                    //      CountIndicator  
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4; //    ()
input uint STO_KPeriod=5;  // K period 
input uint STO_DPeriod=3;  // D period 
input uint STO_Slowing=3;  // Slowing 
input ENUM_MA_METHOD STO_Method=MODE_SMA; //   
input ENUM_STO_PRICE STO_Price=STO_LOWHIGH; //   
input uint BandsPeriod=10; //   BB
input double BandsDeviation=1.0; // 
input uint RSI_Period=8; //   RSI
input ENUM_APPLIED_PRICE RSI_Price=PRICE_CLOSE; //     RSI
input int Shift=0; //      
//+----------------------------------------------+
//---   ,   
//---      
double IndBuffer1[],IndBuffer2[],IndBuffer3[],IndBuffer4[],IndBuffer5[];
//---   
string Symbol_,Word;
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],ENUM_INDEXBUFFER_TYPE Type)
  {
//---      
   SetIndexBuffer(Number,Buffer,Type);
//---       
   ArraySetAsSeries(Buffer,true);
  }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+    
void PlotInit(int Number,double Empty_Value,int Draw_Begin,int nShift)
  {
//---      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//---       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
  }
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    JS-Stoh-BB-RSI       ");
      return(INIT_FAILED);
     }
//---   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//---    JS-Stoh-BB-RSI_HTF
   Ind_Handle=iCustom(Symbol_,TimeFrame,"JS-Stoh-BB-RSI",STO_KPeriod,STO_DPeriod,STO_Slowing,STO_Method,STO_Price,BandsPeriod,BandsDeviation,RSI_Period,RSI_Price,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      JS-Stoh-BB-RSI");
      return(INIT_FAILED);
     }
//---   
   IndInit(0,IndBuffer1,INDICATOR_DATA);
   IndInit(1,IndBuffer2,INDICATOR_DATA);
   IndInit(2,IndBuffer3,INDICATOR_DATA);
   IndInit(3,IndBuffer4,INDICATOR_DATA);
   IndInit(4,IndBuffer5,INDICATOR_DATA);
//---  
   PlotInit(0,EMPTY_VALUE,0,Shift);
   PlotInit(1,EMPTY_VALUE,0,Shift);
   PlotInit(2,EMPTY_VALUE,0,Shift);
   PlotInit(3,EMPTY_VALUE,0,Shift);
   PlotInit(4,EMPTY_VALUE,0,Shift);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---         
   ArraySetAsSeries(time,true);
//---    
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,IndBuffer1,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,1,IndBuffer2,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,2,IndBuffer3,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,3,IndBuffer4,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,4,IndBuffer5,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb,        //    
                    double&  IndBuf[],        //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      IndBuf[bar]=0.0;
      //---       IndTime
      if(CopyTime(Symbol_,TimeFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //---       Arr
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);
         IndBuf[bar]=Arr[0];
        }
      else IndBuf[bar]=IndBuf[bar+1];
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
