//+---------------------------------------------------------------------+
//|                                                      ColorJ2JMA.mq5 | 
//|                                Copyright  2010,   Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrGray,clrBlue,clrRed
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "J2JMA"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input double Length1 = 5; //    
input double Length2 = 5; //    
input double Phase1= 100; //   
                          //    -100 ... +100,     
input double Phase2=100;  //   
                          //    -100 ... +100,     
input Applied_price_ IPC=PRICE_CLOSE_; //  
/* ,      ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input int Shift=0; //      
input int PriceShift=0; //      
//+-----------------------------------+
//----  
double J2JMA[];
double ColorJ2JMA[];
//----
double dPriceShift;
//+------------------------------------------------------------------+
//|   CJJMA                                            |
//+------------------------------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+------------------------------------------------------------------+   
//| J2JMA indicator initialization function                          |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----      
   SetIndexBuffer(0,J2JMA,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,62);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"J2JMA");
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     ,     
   SetIndexBuffer(1,ColorJ2JMA,INDICATOR_COLOR_INDEX);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,62);
//---      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----      
   string shortname;
   StringConcatenate(shortname,"J2JMA( Length1 = ",Length1,", Length2 = ",Length2,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----    CJJMA   JJMASeries_Cls.mqh
   CJJMA JMA;
//----       
   JMA.JJMALengthCheck("Length1", (int)Length1);
   JMA.JJMALengthCheck("Length2", (int)Length2);
//----       
   JMA.JJMAPhaseCheck("Phase1", (int)Phase1);
   JMA.JJMAPhaseCheck("Phase2", (int)Phase2);
//----    
   dPriceShift=_Point*PriceShift;
//----  
  }
//+------------------------------------------------------------------+ 
//| J2JMA iteration function                                         | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<60) return(0);
//----       
   double price_,j1jma,j2jma;
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//----    CJJMA   JJMASeries_Cls.mqh
   static CJJMA JMA1,JMA2;
//----    
   for(bar=first; bar<rates_total; bar++)
     {
      //----   PriceSeries     price_
      price_=PriceSeries(IPC,bar,open,low,high,close);
      //----    JJMASeries
      //----  Phase  Length      (Din = 0)
      //----     begin   30, ..   JMA 
      j1jma = JMA1.JJMASeries( 0, prev_calculated, rates_total, 0, Phase1, Length1, price_, bar, false);
      j2jma = JMA2.JJMASeries(30, prev_calculated, rates_total, 0, Phase2, Length2,  j1jma, bar, false);
      //----       
      J2JMA[bar]=j2jma+dPriceShift;
     }
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first++;
//----     
   for(bar=first; bar<rates_total; bar++)
     {
      ColorJ2JMA[bar]=0;
      if(J2JMA[bar-1]<J2JMA[bar]) ColorJ2JMA[bar]=1;
      if(J2JMA[bar-1]>J2JMA[bar]) ColorJ2JMA[bar]=2;
     }
//----
   return(rates_total);
  }
//+------------------------------------------------------------------+
