//+------------------------------------------------------------------+
//|                                             DayExtremumZones.mq5 |
//|                                                         Tapochun |
//|                         https://login.mql5.com/ru/users/tapochun |
//+------------------------------------------------------------------+
#property copyright "Tapochun"
#property link      "https://login.mql5.com/ru/users/tapochun"
#property version   "1.01"
#property indicator_chart_window
#property description "           ."
#property description "  DailySize https://www.mql5.com/ru/code/13323"
#property indicator_plots 2
#property indicator_buffers 4
//+------------------------------------------------------------------+
//|  															|
//+------------------------------------------------------------------+
double bufW[];         //    
double bufX[];         //   /   

double bufY[];         //    
double bufZ[];         //   
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum ENUM_DW_TYPE   //  -   
  {
   FILLING,         // 
   HISTOGRAM2,      // 
   LINE,            // 
   ARROW,           // 
   NONE             //  
  };

int globHandle;     //     (DailySize)
//+------------------------------------------------------------------+
//|  																|
//+------------------------------------------------------------------+
input int inpUpZonePct = 15;                     //   , %    [0..50]
input int inpDnZonePct = 15;                     //   , %    [0..50]
input ENUM_DW_TYPE inpDrawType=ARROW;            //  
input bool inpDrawInternalZone= true;            //    (  ""/""/" ")
input bool inpShowData = false;                  //      
sinput string d1 = "";                           //   
input int inpUpWidth = 1;                        //    
input int inpDnWidth = 1;                        //    
input color inpUpColor= clrLightBlue;            //    
input color inpDnColor = clrSpringGreen;         //    
sinput string d2 = "";                           //    ""/""
input ENUM_LINE_STYLE inpUpStyle = STYLE_DOT;    //  / 
input ENUM_LINE_STYLE inpDnStyle = STYLE_DOT;    //  / 
sinput string d3 = "";                           //    ""
input int inpUpArrowCode = 158;                  //     (  "")
input int inpDnArrowCode = 158;                  //     (  "")
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   if(inpUpZonePct<0 || inpUpZonePct>50 || 
      inpDnZonePct<0 || inpDnZonePct>50)
     {
      Print(__FILE__,": !        0  50%.   !");
      return( INIT_PARAMETERS_INCORRECT );
     }
//---
   if(_Period>PERIOD_H2)
     {
      Print(__FILE__,": !         H2!");
      return( INIT_PARAMETERS_INCORRECT );
     }
//---
   if(( inpDrawType==FILLING || inpDrawType==HISTOGRAM2) &&
      (inpUpZonePct==0 || inpDnZonePct==0))
     {
      Print(__FILE__,": !   ''  ''      > 0.   !");
      return( INIT_PARAMETERS_INCORRECT );
     }
//---   
   SetIndexBuffer(0,bufW,INDICATOR_DATA);
   SetIndexBuffer(1,bufX,INDICATOR_DATA);
//---
   SetIndexBuffer(2,bufY,INDICATOR_DATA);
   SetIndexBuffer(3,bufZ,INDICATOR_DATA);
//---   
   switch(inpDrawType)
     {
      case FILLING:
         PlotIndexSetInteger(0,PLOT_DRAW_TYPE,DRAW_FILLING);
         PlotIndexSetInteger(1,PLOT_DRAW_TYPE,DRAW_FILLING);
         //---
         PlotIndexSetString(0,PLOT_LABEL,"dez: up;dez: upZone");
         PlotIndexSetString(1,PLOT_LABEL,"dez: dn;dez: dnZone");
         //---
         PlotIndexSetInteger(0,PLOT_COLOR_INDEXES,2);
         PlotIndexSetInteger(1,PLOT_COLOR_INDEXES,2);
         //---
         PlotIndexSetInteger(0,PLOT_LINE_COLOR,0,inpUpColor);
         PlotIndexSetInteger(0,PLOT_LINE_COLOR,1,inpUpColor);
         //---
         PlotIndexSetInteger(1,PLOT_LINE_COLOR,0,inpDnColor);
         PlotIndexSetInteger(1,PLOT_LINE_COLOR,1,inpDnColor);
         break;
      case HISTOGRAM2:
         PlotIndexSetInteger(0,PLOT_DRAW_TYPE,DRAW_HISTOGRAM2);
         PlotIndexSetInteger(1,PLOT_DRAW_TYPE,DRAW_HISTOGRAM2);
         //---
         PlotIndexSetString(0,PLOT_LABEL,"dez: up;dez: upZone");
         PlotIndexSetString(1,PLOT_LABEL,"dez: dn;dez: dnZone");
         //---
         PlotIndexSetInteger(0,PLOT_LINE_STYLE,inpUpStyle);
         PlotIndexSetInteger(1,PLOT_LINE_STYLE,inpDnStyle);
         break;
      case LINE:
         PlotIndexSetInteger(0,PLOT_DRAW_TYPE,DRAW_LINE);
         PlotIndexSetInteger(1,PLOT_DRAW_TYPE,DRAW_LINE);
         //---
         PlotIndexSetInteger(0,PLOT_LINE_STYLE,inpUpStyle);
         PlotIndexSetInteger(1,PLOT_LINE_STYLE,inpDnStyle);
         //---
         PlotIndexSetString(0,PLOT_LABEL,"dez: up");
         PlotIndexSetString(1,PLOT_LABEL,"dez: dn");
         //---
         PlotIndexSetInteger(0,PLOT_LINE_COLOR,inpUpColor);
         PlotIndexSetInteger(1,PLOT_LINE_COLOR,inpDnColor);
         break;
      case ARROW:
         PlotIndexSetInteger(0,PLOT_DRAW_TYPE,DRAW_ARROW);
         PlotIndexSetInteger(1,PLOT_DRAW_TYPE,DRAW_ARROW);
         //---
         PlotIndexSetInteger(0,PLOT_ARROW,inpUpArrowCode);
         PlotIndexSetInteger(1,PLOT_ARROW,inpDnArrowCode);
         //---
         PlotIndexSetString(0,PLOT_LABEL,"dez: up");
         PlotIndexSetString(1,PLOT_LABEL,"dez: dn");
         //---
         PlotIndexSetInteger(0,PLOT_LINE_COLOR,inpUpColor);
         PlotIndexSetInteger(1,PLOT_LINE_COLOR,inpDnColor);
         break;
      case NONE:
         PlotIndexSetInteger(0,PLOT_DRAW_TYPE,DRAW_NONE);
         PlotIndexSetInteger(1,PLOT_DRAW_TYPE,DRAW_NONE);
         //---
         PlotIndexSetString(0,PLOT_LABEL,"dez: up");
         PlotIndexSetString(1,PLOT_LABEL,"dez: dn");
         break;
      default:
         Print(__FUNCTION__,": !   : "+EnumToString(inpDrawType));
         return( INIT_FAILED );
     }
//---  
   PlotIndexSetInteger(0,PLOT_LINE_WIDTH,inpUpWidth);
   PlotIndexSetInteger(1,PLOT_LINE_WIDTH,inpDnWidth);
//---    
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---    
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---      
   PlotIndexSetInteger(0,PLOT_SHOW_DATA,inpShowData);
   PlotIndexSetInteger(1,PLOT_SHOW_DATA,inpShowData);
//---    
   bool answer=InitializeIndicatorHandle(globHandle);
   if( !answer ) return( INIT_FAILED );
//---
   return( INIT_SUCCEEDED );
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---   
   if( rates_total <= 0 ) return( 0 );
//---
   static int dNum;                         //   
   static double dHigh = 0.0;               //  
   static double dLow = DBL_MAX;            //  
//---
   bool answer;                             //    
   int firstBar = rates_total-2;            //    
   int firstInd = 0;                        //       
   double sizes[];                          //  -    
//---
   if(prev_calculated!=0) //    
     {
      if(rates_total>prev_calculated) //    
        {
         //---     
         const int n=rates_total-1;         //   
         bufW[ n ] = EMPTY_VALUE;
         bufX[ n ] = EMPTY_VALUE;
         bufY[ n ] = EMPTY_VALUE;
         bufZ[ n ] = EMPTY_VALUE;
         //---       
         answer=GetIndicatorData(globHandle,0,1,1,sizes,"DailySize");
         if( !answer ) return( prev_calculated );
        }
      else return(prev_calculated);         //    - 
     }
   else                                     //   
     {
      //---     
      ArrayInitialize(bufW,EMPTY_VALUE);
      ArrayInitialize(bufX,EMPTY_VALUE);
      ArrayInitialize(bufY,EMPTY_VALUE);
      ArrayInitialize(bufZ,EMPTY_VALUE);
      //---       
      firstBar=GetFirstBar(time,rates_total,dNum);
      if( firstBar == 0 ) return( prev_calculated );
      //---         
      firstInd=firstBar;
      //---       
      answer=GetIndicatorData(globHandle,0,0,rates_total,sizes,"DailySize");
      if( !answer ) return( prev_calculated );
     }
//---
   int iNum;                                    //    i   
   for(int i=firstBar,j=firstInd; i<rates_total-1; i++,j++)
     {
      iNum=GetDayNumber(time[i]);         //     i 
      if(dNum!=iNum) //    
        {
         //---   
         dNum = iNum;                           //     
         dHigh = high[ i ];                     //   i 
         dLow= low[ i ];                        //   i 
        }
      else                                     //    
        {
         //---    / 
         if( high[ i ] > dHigh )                //    i   
            dHigh = high[ i ];                  //      

         if( low[ i ] < dLow )                   //    i   
            dLow = low[ i ];                     //      
        }
      //---
      switch(inpDrawType) //     
        {
         case FILLING:                           //  - 
         case HISTOGRAM2:                        //  - 
            bufW[i]=dHigh;                                             //  
            bufX[i]=bufW[i]-sizes[j]*inpUpZonePct/100*_Point;   //   
            //---
            bufY[ i ] = dLow;                                             //  
            bufZ[ i ] = bufY[ i ] + sizes[ j ]*inpDnZonePct/100*_Point;   //   
            break;
         case LINE:                              //  - 
         case ARROW:                           //  - 
         case NONE:                              //  -  
            if(inpDrawInternalZone) //      
              {
               bufW[ i ]= dHigh-sizes[ j ]*inpUpZonePct/100*_Point;      //   
               bufX[ i ] = dLow+sizes[ j ]*inpDnZonePct/100*_Point;      //   
              }
            else                               //    
              {
               bufW[ i ]= dHigh;               //  
               bufX[ i ] = dLow;               //  
              }
            break;
         default:
            Print(__FUNCTION__,": !   : "+EnumToString(inpDrawType));
            return( rates_total );
        }
     }
//---
   return( rates_total );
  }
//+------------------------------------------------------------------+
//|    										|
//+------------------------------------------------------------------+
bool GetIndicatorData(const int handle,           //  
                      const int bufferNum,        //    
                      const int startPos,         //    
                      const int count,            //   
                      double &array[],            //   (out)
                      string strIndName = ""      //   (   )
                      )
  {
   int num=CopyBuffer(handle,bufferNum,startPos,count,array);      //  
   if(num==-1) //    
     {
      Print(__FUNCTION__,":  #",GetLastError(),".   "+strIndName+"  .  : ",num);
      return(false);                                                      //  
     }
   return(true);                                                         //    -  
  }
//+------------------------------------------------------------------+
//|       					|
//+------------------------------------------------------------------+
int GetFirstBar(const datetime &time[],     //       
                const int rates_total,      //   
                int &dayNum                 //    (out)
                )
  {
   int prev = GetDayNumber( time[ 0 ] );    //     
   int curr;                                //     
   for(int i=1; i<rates_total; i++) //    
     {
      curr = GetDayNumber( time[ i ] );     //      
      if( curr == prev) continue;           //    -   . 
      else                                  //    
        {
         dayNum = curr;                     //     
         return( i );                       //      
        }
     }
//---
   Print(__FUNCTION__,":   ..");
   return(0);                             //  0
  }
//+------------------------------------------------------------------+
//|     											|
//+------------------------------------------------------------------+
int GetDayNumber(const datetime time) //  
  {
   MqlDateTime tStr;                        //  
   TimeToStruct( time, tStr );              //   
   return( tStr.day );                      //    
  }
//+------------------------------------------------------------------+
//|     					|
//+------------------------------------------------------------------+
bool InitializeIndicatorHandle(int &handle) //   (out)
  {
   handle=iCustom(_Symbol,_Period,"DailySize");   //   ..
   if(handle==INVALID_HANDLE) //    
     {
      Print(__FUNCTION__,":  #",_LastError,".   DailySize  !");
      return(false);                                    //   
     }
   else return(true);                                 //    -  
  }
//+------------------------------------------------------------------+
