//+----------------------------------------------------------------------+
//|                                                          Impulse.mq5 | 
//|                                                Copyright  2006, Gep | 
//| http://www.arkworldmarket.ru/forum/showthread.php?t=966&page=2&pp=10 | 
//+----------------------------------------------------------------------+ 
#property copyright "Copyright  2006, Gep"
#property link "http://www.arkworldmarket.ru/forum/showthread.php?t=966&page=2&pp=10"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "Impulse"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor clrMagenta
#property indicator_levelstyle STYLE_SOLID
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Length=14;  //  
input int  Shift=0;    //      
//+----------------------------------------------+
//----   ,    
//----      
double IndBuffer[];
//----
double LenPoint;
//----      
int min_rates_total,Len;
//+------------------------------------------------------------------+   
//| Impulse indicator initialization function                        | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(Length+1);
   LenPoint=Length*_Point;
   Len=int(Length-1);
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----      
   string shortname;
   StringConcatenate(shortname,"Impulse(",Length,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| Impulse iteration function                                       | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----        
   int first,bar;
   double dif;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      dif=0;
      for(int iii=bar-Len; iii<=bar; iii++) dif+=close[iii]-open[iii];    
      IndBuffer[bar]=MathRound(dif/LenPoint);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
