//+------------------------------------------------------------------+
//|                                                      i-VaR95.mq5 |
//|                                       Copyright  2009, piccioli | 
//|                                    http://piccstick.blogspot.com |
//+------------------------------------------------------------------+
//|              |
//|                    |
//|  - Simple Historical Volatility                                  |
//|  - Exponential Historical Volatility                             |
//|  - High-Low Historical Volatility                                |
//|                                                                  |  
//|  :                                             |
//| 1.                    |
//|                                                     |
//| 2.       ATR, |
//|       , ,   , |
//| 3.   VaR  95- ,       |
//|           (     | 
//|    5- ),                |
//|     5%  ,               |
//|     (grznt)                                             |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, piccioli@gmail.com"
#property link      "http://piccstick.blogspot.com"
//----
#property description "    "
#property description " : "
#property description "1.            "
#property description "2.       ATR, |"
#property description "      , ,   , "
#property description "3.   VaR  95- ,"
#property description "         ,     "
#property description "     5%  ,    (grznt)"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----     
#property indicator_color1 clrGray,clrIndianRed,clrDodgerBlue
//----   -  
#property indicator_style1 STYLE_SOLID
//----     4
#property indicator_width1  2
//----   
#property indicator_label1  "HistVolatility"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum MODE // 
  {
   SHV = 1,     //Simple Historical Volatility
   EHV,         //Exponential Historical Volatility
   HLHV,        //High-Low Historical Volatility
   VaR95        //95- VaR
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int HV_Period = 21;     //    
input MODE Mode=SHV;          //        
input double decline=0.94;    //  
                              //    0.94
                              //      - 
input int grznt=3;            //     95% VaR
input int Shift=0;            //      
//+-----------------------------------+
//----  
double LineBuffer[],ColorLineBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| HistVolatility initialization function                           | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=HV_Period+1;
//----      
   SetIndexBuffer(0,LineBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total+1);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(LineBuffer,true);
//----     ,     
   SetIndexBuffer(1,ColorLineBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorLineBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"Historical Volatility(",HV_Period,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| HistVolatility iteration function                                | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----        
   int limit,bar;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_total; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//----         
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(spread,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)LineBuffer[bar]=HistoricalVolatility(Mode,low,high,close,spread,bar);
//----
   if(prev_calculated>rates_total || prev_calculated<=0) limit--;
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ColorLineBuffer[bar]=0;
      if(LineBuffer[bar]>LineBuffer[bar+1]) ColorLineBuffer[bar]=2;
      if(LineBuffer[bar]<LineBuffer[bar+1]) ColorLineBuffer[bar]=1;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+
double HistoricalVolatility(MODE mode,const double &Low[],const double &High[],const double &Close[],const int &Spread[],int index)
  {
//----
   int start=int(HV_Period+index-1);
//----
   switch(mode)
     {
      case SHV:
        {
         double tshv=0;
         for(int i=start; i>=index; i--) tshv+=MathLog(Close[i+1]/Close[i+1]);
         tshv/=HV_Period;

         double shv=0;
         for(int i=start; i>=index; i--) shv+=(tshv -(MathLog(Close[i]/Close[i+1])))*(tshv -(MathLog(Close[i]/Close[i+1])));
         return(MathSqrt(shv/(HV_Period-1)));
        }
      //----
      case EHV:
        {
         double tshv=0;
         for(int i=start; i>=index; i--) tshv+=MathLog(Close[i+1]/Close[i+1]);
         tshv/=HV_Period;

         double shv=0;
         for(int i=start; i>=index; i--) shv+=(tshv -(MathLog(Close[i]/Close[i+1])))*(tshv -(MathLog(Close[i]/Close[i+1])));
         shv=MathSqrt(shv/(HV_Period-1));
         double ehv=MathSqrt((1-decline)*shv);
        }
      //----
      case HLHV:
        {
         double hlhv=0;
         for(int i=start; i>=index; i--) hlhv+=(MathLog(High[i]/Low[i])*MathLog(High[i]/Low[i]))/(4*MathLog(2));
         return(MathSqrt(hlhv/HV_Period));
        }
      //----
      case VaR95:
        {
         double tshv=0;
         for(int i=start; i>=index; i--) tshv+=MathLog(Close[i+1]/Close[i+1]);
         tshv/=HV_Period;
         //----
         double shv=0;
         for(int i=start; i>=index; i--) shv+=(tshv -(MathLog(Close[i]/Close[i+1])))*(tshv -(MathLog(Close[i]/Close[i+1])));
         shv=MathSqrt(shv/(HV_Period-1));
         return(1.65 *(shv)*10000*MathSqrt(grznt)+2*Spread[index]);
        }
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+
