//+------------------------------------------------------------------+ 
//|                                                 Chaikin_3HTF.mq5 | 
//|                               Copyright  2013, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2013, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.60"
#property description "  Chaikin         ."
//----     
#property indicator_separate_window
//----    3
#property indicator_buffers 3 
//----     
#property indicator_plots   3
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                  //        
#define INDICATOR_NAME "Chaikin" //    
#define SIZE 3                   //      CountIndicator  
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----     
#property indicator_color1  clrBlue
//----    1  2
#property indicator_width1  2
//----   
#property indicator_label1  "Chaikin 1"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----     
#property indicator_color2  clrTeal
//----    2  3
#property indicator_width2  3
//----   
#property indicator_label2  "Chaikin 2"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----     
#property indicator_color3  clrDeepPink
//----    3  5
#property indicator_width3  5
//----   
#property indicator_label3  "Chaikin 3"
//+-------------------------------------+
//|           |
//+-------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame1=PERIOD_M30; //    1 ( )
input ENUM_TIMEFRAMES TimeFrame2=PERIOD_H1;  //    2 ( )
input ENUM_TIMEFRAMES TimeFrame3=PERIOD_H4;  //    3 ( )
input uint                fast_ma_period=3;       //   
input uint                slow_ma_period=10;      //  
input ENUM_MA_METHOD       ma_method=MODE_LWMA;   //  
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK; // 
input int                 Shift=0;                //      
//+-------------------------------------+
//----   ,   
//----      
double Ind1Buffer[];
double Ind2Buffer[];
double Ind3Buffer[];
//----      
int min_rates_total;
//----      
int Ind1_Handle,Ind2_Handle,Ind3_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame1,TimeFrame2,TimeFrame3)) return(INIT_FAILED);
//----   
   min_rates_total=2;
//----    Chaikin 1
   Ind1_Handle=iChaikin(Symbol(),TimeFrame1,fast_ma_period,slow_ma_period,ma_method,VolumeType);
   if(Ind1_Handle==INVALID_HANDLE)
     {
      Print("      Chaikin 1");
      return(INIT_FAILED);
     }
//----    Chaikin 2
   Ind2_Handle=iChaikin(Symbol(),TimeFrame2,fast_ma_period,slow_ma_period,ma_method,VolumeType);
   if(Ind2_Handle==INVALID_HANDLE)
     {
      Print("      Chaikin 2");
      return(INIT_FAILED);
     }
//----    Chaikin 3
   Ind3_Handle=iChaikin(Symbol(),TimeFrame3,fast_ma_period,slow_ma_period,ma_method,VolumeType);
   if(Ind3_Handle==INVALID_HANDLE)
     {
      Print("      Chaikin 3");
      return(INIT_FAILED);
     }
//----   
   IndInit(0,Ind1Buffer,0.0,min_rates_total,Shift);
   IndInit(1,Ind2Buffer,0.0,min_rates_total,Shift);
   IndInit(2,Ind3Buffer,0.0,min_rates_total,Shift);
//----           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",
                     GetStringTimeframe(TimeFrame1),", ",
                     GetStringTimeframe(TimeFrame2),", ",
                     GetStringTimeframe(TimeFrame3),")");

   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind1_Handle)<Bars(Symbol(),TimeFrame1)) return(prev_calculated);
   if(BarsCalculated(Ind2_Handle)<Bars(Symbol(),TimeFrame2)) return(prev_calculated);
   if(BarsCalculated(Ind3_Handle)<Bars(Symbol(),TimeFrame3)) return(prev_calculated);
//----         
   ArraySetAsSeries(time,true);
//----
   if(!CountIndicator(0,NULL,TimeFrame1,Ind1_Handle,0,Ind1Buffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(1,NULL,TimeFrame2,Ind2_Handle,0,Ind2Buffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(2,NULL,TimeFrame3,Ind3_Handle,0,Ind3Buffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],double Empty_Value,int Draw_Begin,int nShift)
  {
//----      
   SetIndexBuffer(Number,Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//----   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//----    2    Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//----       
   ArraySetAsSeries(Buffer,true);
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb,        //    
                    double&  IndBuf[],        //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//----
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//----     
//----    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuf[bar]=0.0;
      //----       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //----
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //----       Arr
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);
         IndBuf[bar]=Arr[0];
        }
      else IndBuf[bar]=IndBuf[bar+1];
     }
//----     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame1, //    1 ( )
                     ENUM_TIMEFRAMES TFrame2, //    2 ( )
                     ENUM_TIMEFRAMES TFrame3) //    3 ( )
  {
//----     
   if(TFrame1<Period() && TFrame1!=PERIOD_CURRENT)
     {
      Print("  1   "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
   if(TFrame2<=TFrame1)
     {
      Print("  2   "+IndName+"      1!");
      Print("    !");
      return(RESET);
     }
   if(TFrame3<=TFrame2)
     {
      Print("  3   "+IndName+"      2!");
      Print("    !");
      return(RESET);
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
