//+------------------------------------------------------------------+ 
//|                                                     Flat_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----   
#property version   "1.60"
//----     
#property indicator_separate_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_HISTOGRAM
//----     
#property indicator_color1  clrGray,clrBlue,clrMagenta,clrRed
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "Flat"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum ENUM_WIDTH // 
  {
   w_1=0,  //1
   w_2,    //2
   w_3,    //3
   w_4,    //4
   w_5     //5
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4; //  
input uint Smooth=10; //  
input ENUM_MA_METHOD ma_method=MODE_SMA; //  
input ENUM_APPLIED_PRICE  applied_price=PRICE_CLOSE; //  
input uint HLRef=100;
input int Shift=0; //      
input uint ExtraHighLevel=60; //   
input uint HighLevel=40; //   
input uint LowLevel=20; //   
input ENUM_LINE_STYLE LevelStyle=STYLE_DASHDOTDOT; //   
input color LevelColor=clrBlue; //  
input ENUM_WIDTH LevelWidth=w_1; //  
input bool ReDraw=true; //      
//+----------------------------------------------+
//----      
int min_rates_total;
//----      
int Ind_Handle;
//----   ,    
//----      
double IndBuffer[],ColorIndBuffer[];
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {
//----
   return(StringSubstr(EnumToString(timeframe),7,-1));
  }
//+------------------------------------------------------------------+    
//| Ind indicator initialization function                            | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_total=3;
//----     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    Flat       ");
      return(INIT_FAILED);
     }
//----    Flat
   Ind_Handle=iCustom(Symbol(),TimeFrame,"Flat",Smooth,ma_method,applied_price,HLRef,0,ExtraHighLevel,HighLevel,LowLevel,LevelStyle,LevelColor,LevelWidth);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      Flat");
      return(INIT_FAILED);
     }
//----    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(IndBuffer,true);
//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"Flat HTF( ",GetStringTimeframe(TimeFrame)," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----    
   IndicatorSetInteger(INDICATOR_LEVELS,3);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,ExtraHighLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,HighLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,LowLevel);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,LevelColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,LevelStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,0,LevelWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,LevelColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,LevelStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,1,LevelWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,LevelColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,LevelStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,2,LevelWidth);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Ind iteration function                                           | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//----   
   int limit,bar;
//----       
   double Ind[2],Col[1];
   datetime IndTime[1];
   static uint LastCountBar;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       
//----         
   ArraySetAsSeries(time,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuffer[bar]=EMPTY_VALUE;
      ColorIndBuffer[bar]=0;
      //----      
      if(CopyTime(Symbol(),TimeFrame,time[bar],1,IndTime)<=0) return(RESET);
      //----
      if(time[bar]>=IndTime[0] && time[bar+1]<IndTime[0])
        {
         LastCountBar=bar;
         //----      
         if(CopyBuffer(Ind_Handle,1,time[bar],1,Ind)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,2,time[bar],1,Col)<=0) return(RESET);
         //----      
         IndBuffer[bar]=Ind[0];
         ColorIndBuffer[bar]=Col[0];
        }
      //----
      if(ReDraw)
        {
         if(IndBuffer[bar+1]!=EMPTY_VALUE && IndBuffer[bar]==EMPTY_VALUE)
           {
            IndBuffer[bar]=IndBuffer[bar+1];
            ColorIndBuffer[bar]=ColorIndBuffer[bar+1];
           }
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
