//+------------------------------------------------------------------+
//|                      Donchian Channels - Generalized version.mq4 |
//|                         Copyright  2005, Luis Guilherme Damiani |
//|                                      http://www.damianifx.com.br |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, Luis Guilherme Damiani"
#property link      "http://www.damianifx.com.br"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 3 
//----    
#property indicator_plots   3
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1 OliveDrab
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "Upper Donchian"
//----     
#property indicator_type2   DRAW_LINE
//----        
#property indicator_color2 Gray
//----   -  
#property indicator_style2  STYLE_SOLID
//----     1
#property indicator_width2  1
//----   
#property indicator_label2  "Middle Donchian"
//----     
#property indicator_type3   DRAW_LINE
//----        
#property indicator_color3 PaleVioletRed
//----   -  
#property indicator_style3  STYLE_SOLID
//----     1
#property indicator_width3  1
//----   
#property indicator_label3  "Lower Donchian"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_Extrem // 
  {
   HIGH_LOW,
   HIGH_LOW_OPEN,
   HIGH_LOW_CLOSE,
   OPEN_HIGH_LOW,
   CLOSE_HIGH_LOW
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int DonchianPeriod=20; //  
input Applied_Extrem Extremes=HIGH_LOW; //  
input int Margins=-2;
input int Shift=0; //      
//+-----------------------------------+
//----  
double UpperBuffer[];
double MiddleBuffer[];
double LowerBuffer[];
//+------------------------------------------------------------------+
//| Searching index of the highest bar                               |
//+------------------------------------------------------------------+
int iHighest(const double &array[],//      
             int count,            //    (        ), 
                                   //      
             int startPos)         //  (   )  , 
                                   //      

  {
//----
   int index=startPos;
//----     
   if(startPos<0)
     {
      Print("    iHighest, startPos = ",startPos);
      return(0);
     }
//----   startPos  
   if(startPos-count<0)
      count=startPos;
//----
   double max=array[startPos];
//----  
   for(int i=startPos; i>startPos-count; i--)
     {
      if(array[i]>max)
        {
         index=i;
         max=array[i];
        }
     }
//----    
   return(index);
  }
//+------------------------------------------------------------------+
//| Searching index of the lowest bar                                |
//+------------------------------------------------------------------+
int iLowest(const double &array[],//      
            int count,            //    (        ), 
                                  //      
            int startPos) //  (   )  , 
                          //      
  {
//----
   int index=startPos;
//----     
   if(startPos<0)
     {
      Print("    iLowest, startPos = ",startPos);
      return(0);
     }
//----   startPos  
   if(startPos-count<0)
      count=startPos;
//----
   double min=array[startPos];
//----  
   for(int i=startPos; i>startPos-count; i--)
     {
      if(array[i]<min)
        {
         index=i;
         min=array[i];
        }
     }
//----    
   return(index);
  }
//+------------------------------------------------------------------+    
//| Donchian Channel indicator initialization function               | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----      
   SetIndexBuffer(0,UpperBuffer,INDICATOR_DATA);
//----    1    AroonShift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,DonchianPeriod-1);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"Upper Donchian");
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   SetIndexBuffer(1,MiddleBuffer,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,DonchianPeriod-1);
//---      DataWindow
   PlotIndexSetString(1,PLOT_LABEL,"Middle Donchian");
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   SetIndexBuffer(2,LowerBuffer,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       3
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,DonchianPeriod-1);
//---      DataWindow
   PlotIndexSetString(2,PLOT_LABEL,"Lower Donchian");
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   StringConcatenate(shortname,"Donchian( DonchianPeriod = ",DonchianPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| Donchian Channel iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<DonchianPeriod+1) return(0);
//----       
   double smin,smax,SsMax=0,SsMin=0;
//----   
   int first,bar;
//----    first    
   if(prev_calculated==0) //      
     {
      first=DonchianPeriod; //      
     }
   else
     {
      first=prev_calculated-1;//      
     }
//----    
   for(bar=first; bar<rates_total; bar++)
     {
      switch(Extremes)
        {
         case HIGH_LOW:
            SsMax=high[iHighest(high,DonchianPeriod,bar)];
            SsMin=low[iLowest(low,DonchianPeriod,bar)];
            break;
            //----
         case HIGH_LOW_OPEN:
            SsMax=(open[iHighest(open,DonchianPeriod,bar)]+high[iHighest(high,DonchianPeriod,bar)])/2;
            SsMin=(open[iLowest(open,DonchianPeriod,bar)]+low[iLowest(high,DonchianPeriod,bar)])/2;
            break;
            //----
         case HIGH_LOW_CLOSE:
            SsMax=(close[iHighest(close,DonchianPeriod,bar)]+high[iHighest(high,DonchianPeriod,bar)])/2;
            SsMin=(close[iLowest(close,DonchianPeriod,bar)]+low[iLowest(high,DonchianPeriod,bar)])/2;
            break;
            //----
         case OPEN_HIGH_LOW:
            SsMax=open[iHighest(open,DonchianPeriod,bar)];
            SsMin=open[iLowest(open,DonchianPeriod,bar)];
            break;
            //----
         case CLOSE_HIGH_LOW:
            SsMax=close[iHighest(close,DonchianPeriod,bar)];
            SsMin=close[iLowest(close,DonchianPeriod,bar)];
            break;
        }
      //----
      smin=SsMin+(SsMax-SsMin)*Margins/100;
      smax=SsMax-(SsMax-SsMin)*Margins/100;
      UpperBuffer[bar]=smax;
      LowerBuffer[bar]=smin;
      MiddleBuffer[bar]=(smax+smin)/2.0;
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
