//+------------------------------------------------------------------+
//|                                                   ExtremLine.mq5 |
//|                                 Copyright  2014 Serkov Alexandr | 
//|                                          serkov-alexandr@mail.ru | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2014 Serkov Alexandr"
//----    
#property link "serkov-alexandr@mail.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----         
#property indicator_color1  clrLime
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  4
#property indicator_width1  4
//----    
#property indicator_label1  "Bulls ExtremLine"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----         
#property indicator_color2  clrRed
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  4
#property indicator_width2  4
//----    
#property indicator_label2  "Bears ExtremLine"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint IndPeriod= 10; //   
input int IndShift = 0;   //       
//+----------------------------------------------+
//----   ,    
//----      
double BullsIndBuffer[];
double BearsIndBuffer[];
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----    
   min_rates_total=int(IndPeriod);
//----    BullsIndBuffer   
   SetIndexBuffer(0,BullsIndBuffer,INDICATOR_DATA);
//----    1    IndShift
   PlotIndexSetInteger(0,PLOT_SHIFT,IndShift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----    BearsIndBuffer   
   SetIndexBuffer(1,BearsIndBuffer,INDICATOR_DATA);
//----    2    IndShift
   PlotIndexSetInteger(1,PLOT_SHIFT,IndShift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----      
   string shortname;
   StringConcatenate(shortname,"ExtremLine(",IndPeriod,", ",IndShift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----    
   int first,bar;
   bool dir=false;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      if(high[bar]>high[bar-IndPeriod]) dir=true;
      if(low[bar]<low[bar-IndPeriod]) dir=false;
      if(dir==true)
        {
         BullsIndBuffer[bar]=high[bar];
         BullsIndBuffer[bar-1]=high[bar-1];
         BearsIndBuffer[bar]=0.0;
        }
      else
        {
         BearsIndBuffer[bar]=low[bar];
         BearsIndBuffer[bar-1]=low[bar-1];
         BullsIndBuffer[bar]=0.0;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
