//+------------------------------------------------------------------+
//|                                                  EMABands_v1.mq5 |
//|                                  Copyright  2006, Forex-TSD.com |
//|                         Written by IgorAD,igorad2003@yahoo.co.uk |   
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |                                      
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Forex-TSD.com "
#property link      "http://www.forex-tsd.com/"
//----   
#property version   "1.00"
#property description "MACD_Cloud"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//----    4
#property indicator_buffers 4 
//----    
#property indicator_plots   2
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET  0 //        
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrPaleGreen
//----   
#property indicator_label1  "Upper Cloud"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type2   DRAW_FILLING
//----     
#property indicator_color2  clrPink
//----   
#property indicator_label2  "Lower Cloud"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int   MAPeriod=13;
input  ENUM_MA_METHOD   MAType=MODE_EMA;
input uint Delta=150;
//+-----------------------------------+
//----      
int  min_rates_total;
//----   ,    
//----      
double ExtHHBuffer[];
double ExtHLBuffer[];
double ExtLHBuffer[];
double ExtLLBuffer[];
//----
double dDelta;
//----      
int MAh_Handle,MAl_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----     
   min_rates_total=int(MAPeriod);
   dDelta=Delta*_Point;
//----    iMA h
   MAh_Handle=iMA(NULL,0,MAPeriod,0,MAType,PRICE_HIGH);
   if(MAh_Handle==INVALID_HANDLE)
     {
      Print("      iMA h");
      return(INIT_FAILED);
     }
//----    iMA l
   MAl_Handle=iMA(NULL,0,MAPeriod,0,MAType,PRICE_LOW);
   if(MAl_Handle==INVALID_HANDLE)
     {
      Print("      iMA l");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,ExtHHBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtHHBuffer,true);
//----      
   SetIndexBuffer(1,ExtHLBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtHLBuffer,true);
//----      
   SetIndexBuffer(2,ExtLHBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtLHBuffer,true);
//----      
   SetIndexBuffer(3,ExtLLBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtLLBuffer,true);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"EMABands_v1");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[])
  {
//----       
   if(BarsCalculated(MAh_Handle)<rates_total
      || BarsCalculated(MAl_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//----    
   int to_copy,limit;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-min_rates_total-1; //      
   else limit=rates_total-prev_calculated;  //       
//----
   to_copy=limit+1;
//----      
   if(CopyBuffer(MAh_Handle,MAIN_LINE,0,to_copy,ExtHLBuffer)<=0) return(RESET);
   if(CopyBuffer(MAl_Handle,MAIN_LINE,0,to_copy,ExtLHBuffer)<=0) return(RESET);
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ExtHHBuffer[bar]=ExtHLBuffer[bar]+dDelta;
      ExtLLBuffer[bar]=ExtLHBuffer[bar]-dDelta;
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
