//+------------------------------------------------------------------+
//|                                                 Demand_Index.mq5 |
//|                             Copyright  2011,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2011, Nikolay Kositsin"
//----    
#property link "farria@mail.redcom.ru"
#property description "Demand Index"
//----   
#property version   "1.01"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 1
//----    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----       - 
#property indicator_color1  clrMediumSlateBlue
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----   
#property indicator_label1  "Demand Index"
//+-----------------------------------+
//|    CXMA             |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_   //TrendFollow_2 Price 
  };
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method=MODE_SMA; //  
input int XLength=12; //  
input int XPhase=15;  //  
                      //  JJMA    -100 ... +100,     
                      //  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_QUARTER_; //  
/* ,      ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  // 
input int Shift=0; //      
//+----------------------------------------------+
//----   ,   
//----      
double DIBuffer[];
//----      
int StartBars;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   StartBars=XMA1.GetStartBars(XMA_Method,XLength,XPhase)+1;
//----       
   XMA1.XMALengthCheck("XLength", XLength);
   XMA1.XMAPhaseCheck("XPhase", XPhase, XMA_Method);
//----    
//----      
   SetIndexBuffer(0,DIBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  StartBars
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,StartBars);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"Demand Index");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<StartBars) return(0);
//----    
   int first,bar,Sign;
   double AvgTR,Avg,VolAvg,price0,price1,WtCRatio=0.0,VolRatio;
   double Constant,DMI,TempDI,BuyPres,SellPres,BuyP,SellP;
   long Volume;
   static double VolAvg_,BuyPres_,SellPres_;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=1; //      
      //----
      BuyPres_=1;
      SellPres_=1;
      //----
      if(VolumeType==VOLUME_TICK) VolAvg_=double(tick_volume[0]);
      else                        VolAvg_=double(volume[0]);
     }
//----
   else first=prev_calculated-1; //      
//----   
   VolAvg=VolAvg_;
   BuyPres=BuyPres_;
   SellPres=SellPres_;
//----    
   for(bar=first; bar<rates_total; bar++)
     {
      //----        
      if(rates_total!=prev_calculated && bar==0)
        {
         VolAvg_=VolAvg;
         BuyPres_=BuyPres;
         SellPres_=SellPres;
        }
      //----   PriceSeries     price_
      price0=PriceSeries(IPC,bar,  open,low,high,close);
      price1=PriceSeries(IPC,bar-1,open,low,high,close);
      //----
      if(VolumeType==VOLUME_TICK) Volume=long(tick_volume[bar]);
      else                        Volume=long(volume[bar]);
      //----
      Avg=MathMax(high[bar],high[bar-1])-MathMin(low[bar],low[bar-1]);
      AvgTR=XMA1.XMASeries(1,prev_calculated,rates_total,XMA_Method,XPhase,XLength,Avg,bar,false);
      VolAvg=((VolAvg *(XLength-1))+Volume)/XLength;
      //----
      if(price0!=0 && price1!=0 && AvgTR!=0 && VolAvg!=0)
         WtCRatio=(price0-price1)/MathMin(price0,price1);
      //----
      if(VolAvg!=0)VolRatio=Volume/VolAvg;
      else         VolRatio=1;
      //----
      Constant=((price0*3)/AvgTR)*MathAbs(WtCRatio);
      //----
      if(Constant>88) Constant=88;
      //----
      Constant=VolRatio/MathExp(Constant);
      //----
      if(WtCRatio>0)
        {
         BuyP=VolRatio;
         SellP=Constant;
        }
      else
        {
         BuyP=Constant;
         SellP=VolRatio;
        }
      //----
      BuyPres =((BuyPres *(XLength-1))+BuyP )/XLength;
      SellPres=((SellPres*(XLength-1))+SellP)/XLength;
      //----
      TempDI=+1;
      //----
      if(SellPres>BuyPres)
        {
         Sign=-1;
         if(SellPres!=0) TempDI=BuyPres/SellPres;
        }
      else
        {
         Sign=+1;
         if(BuyPres!=0) TempDI=SellPres/BuyPres;
        }
      //----
      TempDI*=Sign;
      //----
      if(TempDI < 0) DMI = -1 - TempDI;
      else           DMI = +1 - TempDI;
      //----
      DIBuffer[bar]=DMI*100.0;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
