//+------------------------------------------------------------------+
//|                                           TSI-OscillatorSign.mq5 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//|                                                                  |
//|                                   Modified from TSI-Osc by Toshi |
//|                                  http://toshi52583.blogspot.com/ |
//+------------------------------------------------------------------+
//|      SmoothAlgorithms.mqh                 |
//|    : __\\MQL5\Include |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        DeepPink 
#property indicator_color1  clrDeepPink
//---    1  1 
#property indicator_width1  1
//---    
#property indicator_label1  "TSI-Oscillator Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        DodgerBlue 
#property indicator_color2  clrDodgerBlue
//---    2  1
#property indicator_width2  1
//---    
#property indicator_label2 "TSI-Oscillator Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|   CMTM                         |
//+----------------------------------------------+
#include<SmoothAlgorithms.mqh>
//+----------------------------------------------+
//----    CMTM   SmoothAlgorithms.mqh
CXMA MTM1,MTM2,ABSMTM1,ABSMTM2;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_      //  
  {
   PRICE_CLOSE_ = 1,     // Close
   PRICE_OPEN_,          // Open
   PRICE_HIGH_,          // High
   PRICE_LOW_,           // Low
   PRICE_MEDIAN_,        // Median Price (HL/2)
   PRICE_TYPICAL_,       // Typical Price (HLC/3)
   PRICE_WEIGHTED_,      // Weighted Close (HLCC/4)
   PRICE_SIMPLE,         // Simple Price (OC/2)
   PRICE_QUARTER_,       // Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  // TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  // TrendFollow_2 Price 
   PRICE_DEMARK_         // Demark Price
  };
//---
/*enum Smooth_Method -     SmoothAlgorithms.mqh
   {
    MODE_SMA_,  // SMA
    MODE_EMA_,  // EMA
    MODE_SMMA_, // SMMA
    MODE_LWMA_, // LWMA
    MODE_JJMA,  // JJMA
    MODE_JurX,  // JurX
    MODE_ParMA, // ParMA
    MODE_T3,    // T3
    MODE_VIDYA, // VIDYA
    MODE_AMA,   // AMA
   }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method First_Method=MODE_SMA;  //   1
input int First_Length=12;                  //   1
input int First_Phase=15;                   //   1
input Smooth_Method Second_Method=MODE_SMA; //   2
input int Second_Length=12;                 //   2
input int Second_Phase=15;                  //   2
input Applied_price_ IPC=PRICE_CLOSE;       //  
input int Shift=0;                          //      
input uint TriggerShift=1;                  //     
//+----------------------------------------------+
int ATR_Handle;
//----      
int min_rates_total,min_rates_total1,min_rates_total2;
//----   ,    
//----      
double SellBuffer[],BuyBuffer[];
//----   
int Count[];
double TSI[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;
//----
   Max2=Size;
   Max1=Max2-1;
//----
   count--;
   if(count<0) count=Max1;
//----
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+   
//| TSI indicator initialization function                            | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----    
   int ATR_Period=15;
//----    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----       
   ArrayResize(Count,TriggerShift+1);
   ArrayResize(TSI,TriggerShift+1);
   ArrayInitialize(Count,0);
   ArrayInitialize(TSI,0.0);
//----     
   min_rates_total1=MTM1.GetStartBars(First_Method,First_Length,First_Phase)+1;
   min_rates_total2=min_rates_total1+MTM1.GetStartBars(First_Method,First_Length,First_Phase);
   min_rates_total=int(min_rates_total1+MTM1.GetStartBars(Second_Method,Second_Length,Second_Phase)+TriggerShift);
   min_rates_total=int(MathMax(ATR_Period,min_rates_total))+1;
//----       
   MTM1.XMALengthCheck("First_Length",First_Length);
   MTM1.XMAPhaseCheck("First_Phase",First_Phase, First_Method);
   MTM1.XMALengthCheck("Second_Length",Second_Length);
   MTM1.XMAPhaseCheck("Second_Phase",Second_Phase,Second_Method);
//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,124);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,124);
//----    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----      
   string shortname;
   string Smooth1=MTM1.GetString_MA_Method(First_Method);
   string Smooth2=MTM1.GetString_MA_Method(Second_Method);
   StringConcatenate(shortname,"TSI-OscillatorSign(",Smooth1,", ",First_Length,", ",Smooth2,", ",Second_Length,")");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| TSI iteration function                                           | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----       
   double dprice,absdprice,mtm1,absmtm1,mtm2,absmtm2,Trigger,ATR[1];
//----        
   int first,bar;
   static double Trigger1;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=1;                   //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      dprice=close[bar]-close[bar-1];
      absdprice=MathAbs(dprice);
      //----
      mtm1=MTM1.XMASeries(1,prev_calculated,rates_total,First_Method,First_Phase,First_Length,dprice,bar,false);
      absmtm1=ABSMTM1.XMASeries(1,prev_calculated,rates_total,First_Method,First_Phase,First_Length,absdprice,bar,false);
      //----
      mtm2=MTM2.XMASeries(min_rates_total1,prev_calculated,rates_total,Second_Method,Second_Phase,Second_Length,mtm1,bar,false);
      absmtm2=ABSMTM2.XMASeries(min_rates_total1,prev_calculated,rates_total,Second_Method,Second_Phase,Second_Length,absmtm1,bar,false);
      //----
      if(bar>min_rates_total2) TSI[Count[0]]=100.0*mtm2/absmtm2;
      else TSI[Count[0]]=0;
      //----
      if(bar>min_rates_total) Trigger=TSI[Count[TriggerShift]];
      else                    Trigger=0;
      //---
      if(TSI[Count[1]]<=Trigger1 && TSI[Count[0]]>Trigger)
        {
         //---       ATR[]
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
         BuyBuffer[bar]=low[bar]-ATR[0]*3/8;
        }
      //---
      if(TSI[Count[1]]>=Trigger1 && TSI[Count[0]]<Trigger)
        {
         //---       ATR[]
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
         SellBuffer[bar]=high[bar]+ATR[0]*3/8;
        }
      //----
      if(bar<rates_total-1)
        {
         Recount_ArrayZeroPos(Count,TriggerShift+1);
         Trigger1=Trigger;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
