//+------------------------------------------------------------------+ 
//|                                                  ColorStdDev.mq5 | 
//|                               Copyright  2010, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----   
#property version   "1.01"
//----     
#property indicator_separate_window 
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 clrGray,clrBlue,clrRed,clrMagenta
//----   -  
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1 "StdDev"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint period = 12;                               //  
input ENUM_MA_METHOD MA_Method=MODE_EMA;              //   
input ENUM_APPLIED_PRICE  applied_price=PRICE_CLOSE;  //  
input uint MaxTrendLevel=100;                         //   
input uint MiddLeTrendLevel=40;                       //   
input uint FlatLevel=10;                              //  
//+-----------------------------------+
//---- e 
double StdDevBuffer[],ColorBuffer[];
//----      
int StdDev_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+    
//| StdDev indicator initialization function                         | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(period);
//----    RSI
   StdDev_Handle=iStdDev(NULL,0,period,0,MA_Method,applied_price);
   if(StdDev_Handle==INVALID_HANDLE) Print("      StdDev");
//----    StdDevBuffer   
   SetIndexBuffer(0,StdDevBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----          
   ArraySetAsSeries(StdDevBuffer,true);
//----     ,     
   SetIndexBuffer(1,ColorBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"ColorStdDev( ",period," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----      3   
   IndicatorSetInteger(INDICATOR_LEVELS,3);
//----       
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,MaxTrendLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,MiddLeTrendLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,FlatLevel);
//----             
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,Magenta);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,Blue);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,Gray);
//----       -  
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,STYLE_DASHDOTDOT);
//----  
  }
//+------------------------------------------------------------------+  
//| StdDev iteration function                                         | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(StdDev_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----   
   int limit,to_copy,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      limit=rates_total-1; //      
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+1;
//----      
   if(CopyBuffer(StdDev_Handle,0,0,to_copy,StdDevBuffer)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      StdDevBuffer[bar]/=_Point;
      ColorBuffer[bar]=0;
      if(StdDevBuffer[bar]>MaxTrendLevel) ColorBuffer[bar]=3;
      else if(StdDevBuffer[bar]>MiddLeTrendLevel) ColorBuffer[bar]=2;
      else if(StdDevBuffer[bar]>FlatLevel) ColorBuffer[bar]=1;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
