//+---------------------------------------------------------------------+ 
//|                                               ColorMomentum_AMA.mq5 | 
//|                                Copyright  2010,   Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.11"
//----     
#property indicator_separate_window 
//----   
#property indicator_buffers 5 
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_plots   2
//----      
#property indicator_type1   DRAW_COLOR_HISTOGRAM
#property indicator_type2   DRAW_COLOR_HISTOGRAM
#property indicator_color1  clrBlue,clrGreen
#property indicator_color2  clrMagenta,clrRed
#property indicator_width1  2
#property indicator_width2  2
#property indicator_label1  "Momentum_AMA Upper"
#property indicator_label2  "Momentum_AMA Lower"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint ALength=8;    //  
input uint ama_period=9; //  AMA
input uint fast_ma_period=2;  //   
input uint slow_ma_period=30; //   
input Applied_price_ IPC=PRICE_CLOSE; //  
input double G=2.0; // ,     
input int Shift=0;  //      
//+-----------------------------------+
//----  
double IndMomentum[];
double UpColorsBuffer[];
double LoColorsBuffer[];
double UpperBuffer[];
double LowerBuffer[];
//----
int min_rates_total;
//+------------------------------------------------------------------+
//|   iPriceSeries                                    |
//|   iPriceSeriesAlert                               |
//|   CMomentum  CAMA                                |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh>  
//+------------------------------------------------------------------+    
//| Momentum indicator initialization function                       | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----  
   min_rates_total=int(ALength+ama_period)+2;
//----      
   SetIndexBuffer(4,IndMomentum,INDICATOR_CALCULATIONS);
//----   
   SetIndexBuffer(0,UpperBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,UpColorsBuffer,INDICATOR_COLOR_INDEX);
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
   SetIndexBuffer(2,LowerBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,LoColorsBuffer,INDICATOR_COLOR_INDEX);
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);
//----      
   string shortname;
   StringConcatenate(shortname,"Momentum_AMA( ALength = ",ALength,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----    CJurX   SmoothAlgorithms.mqh
   CMomentum Mom;
//----       
   Mom.MALengthCheck("Length", ALength);
   Mom.MALengthCheck("ama_period", ama_period);
   Mom.MALengthCheck("fast_ma_period", fast_ma_period);
   Mom.MALengthCheck("slow_ma_period", slow_ma_period);
//----  
  }
//+------------------------------------------------------------------+  
//| Momentum iteration function                                      | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double price,momentum,amomentum;
//----        
   int first,bar;
//----    first    
   if(prev_calculated==0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//----    CMomentum  CAMA   SmoothAlgorithms.mqh
   static CMomentum Mom;
   static CAMA AMA;
//----    
   for(bar=first; bar<rates_total; bar++)
     {
      //----   PriceSeries      dprice_
      price=PriceSeries(IPC,bar,open,low,high,close);
      //----    
      momentum=Mom.MomentumSeries(0,prev_calculated,rates_total,ALength,price,bar,false);
      amomentum=AMA.AMASeries(ALength+1,prev_calculated,rates_total,ama_period,fast_ma_period,slow_ma_period,G,momentum,bar,false);
      //----      
      amomentum/=_Point;
      IndMomentum[bar]=amomentum;
      //----
      UpperBuffer[bar]=0.0;
      UpColorsBuffer[bar]=0.0;
      LowerBuffer[bar]=0.0;
      LoColorsBuffer[bar]=0.0;
      //----
      if(bar<=min_rates_total) continue;
      //----
      if(amomentum>0)
        {
         UpperBuffer[bar]=amomentum;
         if(amomentum>IndMomentum[bar-1]) UpColorsBuffer[bar]=1;
        }
      else
        {
         LowerBuffer[bar]=amomentum;
         if(amomentum<IndMomentum[bar-1]) LoColorsBuffer[bar]=1;
        }

     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+ 
