//+------------------------------------------------------------------+ 
//|                                             BollingerBands_b.mq5 | 
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//|                                    Modified by Alejandro Galindo |
//|                                                                  |
//|                                           You are free to use it |
//|                                                                  |
//|      If you want and if this work/modification is helpful to you |
//|             you can send me a PayPal donation to ag@elcactus.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"
//----   
#property version   "1.01"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        clrMediumSlateBlue 
#property indicator_color1 clrMediumSlateBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1 1
//----   
#property indicator_label1  "Bollinger Bands% b"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor clrMagenta
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint BBPeriod=20;                              //     
input double StdDeviation=2;                         // 
input ENUM_APPLIED_PRICE  applied_price=PRICE_CLOSE; //  
input int Shift=0;                                   //      
//+----------------------------------------------+
//----      
int Ind_Handle;
//----  
double IndBuffer[];
//----   
int min_rates_total;
//+------------------------------------------------------------------+    
//| Bollinger Bands% b indicator initialization function             | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(BBPeriod);
//----    iBands
   Ind_Handle=iBands(NULL,0,BBPeriod,0,StdDeviation,applied_price);
   if(Ind_Handle==INVALID_HANDLE) Print("      iBands");
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(IndBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"Bollinger Bands% b",BBPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| Bollinger Bands% b iteration function                            | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(Ind_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   int to_copy,limit,bar;
   double UpBB[],DnBB[];
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//----
   to_copy=limit+1;
//----      
   if(CopyBuffer(Ind_Handle,UPPER_BAND,0,to_copy,UpBB)<=0) return(RESET);
   if(CopyBuffer(Ind_Handle,LOWER_BAND,0,to_copy,DnBB)<=0) return(RESET);
//----         
   ArraySetAsSeries(UpBB,true);
   ArraySetAsSeries(DnBB,true);
   ArraySetAsSeries(close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--) IndBuffer[bar]=(close[bar]-UpBB[bar])/(DnBB[bar]-UpBB[bar]);
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
