//+---------------------------------------------------------------------+
//|                                        MultiStochasticTrend_x10.mq5 | 
//|                                  Copyright  2015, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
#property description ""
//---   
#property version   "1.60"
//---     
#property indicator_separate_window
//---       
#property indicator_height 150
//---        
#property indicator_maximum +10.9
#property indicator_minimum +0.3
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                  //        
#define INDTOTAL 10                              //     
#define INDICATOR_NAME "StochasticTrend_x10"     //    
//+----------------------------------------------+
//---   
#property indicator_buffers 40 // INDTOTAL*4
//---    
#property indicator_plots   20 // INDTOTAL*2
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_COLOR_LINE
//---      
#property indicator_color1 clrMagenta,clrGray,clrMediumSeaGreen
//---   - 
#property indicator_style1  STYLE_SOLID
//---     3
#property indicator_width1  3
//---   
#property indicator_label1  "Signal line 1"
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//---   1   
#property indicator_type2   DRAW_COLOR_ARROW
//---     
#property indicator_color2 clrMagenta,clrGray,clrMediumSeaGreen
//---     5
#property indicator_width2  5
//---   
#property indicator_label2  "Signal Arrow 1"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_COLOR_LINE
//---      
#property indicator_color3 clrMagenta,clrGray,clrMediumSeaGreen
//---   - 
#property indicator_style3  STYLE_SOLID
//---     3
#property indicator_width3  3
//---   
#property indicator_label3  "Signal line 2"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//---   2   
#property indicator_type4   DRAW_COLOR_ARROW
//---     
#property indicator_color4 clrMagenta,clrGray,clrMediumSeaGreen
//---     5
#property indicator_width4  5
//---   
#property indicator_label4  "Signal Arrow 2"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//---   3   
#property indicator_type5   DRAW_COLOR_LINE
//---      
#property indicator_color5 clrMagenta,clrGray,clrMediumSeaGreen
//---   - 
#property indicator_style5  STYLE_SOLID
//---     3
#property indicator_width5  3
//---   
#property indicator_label5  "Signal line 3"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//---   3   
#property indicator_type6   DRAW_COLOR_ARROW
//---     
#property indicator_color6 clrMagenta,clrGray,clrMediumSeaGreen
//---     5
#property indicator_width6  5
//---   
#property indicator_label6  "Signal Arrow 3"
//+----------------------------------------------+
//|    4             |
//+----------------------------------------------+
//---   4   
#property indicator_type7   DRAW_COLOR_LINE
//---      
#property indicator_color7 clrMagenta,clrGray,clrMediumSeaGreen
//---   - 
#property indicator_style7  STYLE_SOLID
//---     3
#property indicator_width7  3
//---   
#property indicator_label7  "Signal line 4"
//+----------------------------------------------+
//|    4             |
//+----------------------------------------------+
//---   4   
#property indicator_type8   DRAW_COLOR_ARROW
//---     
#property indicator_color8 clrMagenta,clrGray,clrMediumSeaGreen
//---     5
#property indicator_width8  5
//---   
#property indicator_label8  "Signal Arrow 4"
//+----------------------------------------------+
//|    5             |
//+----------------------------------------------+
//---   5   
#property indicator_type9   DRAW_COLOR_LINE
//---      
#property indicator_color9 clrMagenta,clrGray,clrMediumSeaGreen
//---   - 
#property indicator_style9  STYLE_SOLID
//---     3
#property indicator_width9  3
//---   
#property indicator_label9  "Signal line 5"
//+----------------------------------------------+
//|    5             |
//+----------------------------------------------+
//---   5   
#property indicator_type10   DRAW_COLOR_ARROW
//---     
#property indicator_color10 clrMagenta,clrGray,clrMediumSeaGreen
//---     5
#property indicator_width10  5
//---   
#property indicator_label10  "Signal Arrow 5"
//+----------------------------------------------+
//|    6             |
//+----------------------------------------------+
//---   6   
#property indicator_type11   DRAW_COLOR_LINE
//---      
#property indicator_color11 clrMagenta,clrGray,clrMediumSeaGreen
//---   - 
#property indicator_style11  STYLE_SOLID
//---     3
#property indicator_width11  3
//---   
#property indicator_label11  "Signal line 6"
//+----------------------------------------------+
//|    6             |
//+----------------------------------------------+
//---   6   
#property indicator_type12   DRAW_COLOR_ARROW
//---     
#property indicator_color12 clrMagenta,clrGray,clrMediumSeaGreen
//---     5
#property indicator_width12  5
//---   
#property indicator_label12  "Signal Arrow 6"
//+----------------------------------------------+
//|    7             |
//+----------------------------------------------+
//---   7   
#property indicator_type13   DRAW_COLOR_LINE
//---      
#property indicator_color13 clrMagenta,clrGray,clrMediumSeaGreen
//---   - 
#property indicator_style13  STYLE_SOLID
//---     3
#property indicator_width13  3
//---   
#property indicator_label13  "Signal line 7"
//+----------------------------------------------+
//|    7             |
//+----------------------------------------------+
//---   7   
#property indicator_type14   DRAW_COLOR_ARROW
//---     
#property indicator_color14 clrMagenta,clrGray,clrMediumSeaGreen
//---     5
#property indicator_width14  5
//---   
#property indicator_label14  "Signal Arrow 7"
//+----------------------------------------------+
//|    8             |
//+----------------------------------------------+
//---   8   
#property indicator_type15   DRAW_COLOR_LINE
//---      
#property indicator_color15 clrMagenta,clrGray,clrMediumSeaGreen
//---   - 
#property indicator_style15  STYLE_SOLID
//---     3
#property indicator_width15  3
//---   
#property indicator_label15  "Signal line 8"
//+----------------------------------------------+
//|    8             |
//+----------------------------------------------+
//---   8   
#property indicator_type16   DRAW_COLOR_ARROW
//---     
#property indicator_color16 clrMagenta,clrGray,clrMediumSeaGreen
//---     5
#property indicator_width16  5
//---   
#property indicator_label16  "Signal Arrow 8"
//+----------------------------------------------+
//|    9             |
//+----------------------------------------------+
//---   9   
#property indicator_type17   DRAW_COLOR_LINE
//---      
#property indicator_color17 clrMagenta,clrGray,clrMediumSeaGreen
//---   - 
#property indicator_style17  STYLE_SOLID
//---     3
#property indicator_width17  3
//---   
#property indicator_label17  "Signal line 9"
//+----------------------------------------------+
//|    9             |
//+----------------------------------------------+
//---   9   
#property indicator_type18   DRAW_COLOR_ARROW
//---     
#property indicator_color18 clrMagenta,clrGray,clrMediumSeaGreen
//---     5
#property indicator_width18  5
//---   
#property indicator_label18  "Signal Arrow 9"
//+----------------------------------------------+
//|    10            |
//+----------------------------------------------+
//---   10   
#property indicator_type19   DRAW_COLOR_LINE
//---      
#property indicator_color19 clrMagenta,clrGray,clrMediumSeaGreen
//---   - 
#property indicator_style19  STYLE_SOLID
//---     3
#property indicator_width19  3
//---   
#property indicator_label19  "Signal line 10"
//+----------------------------------------------+
//|    10            |
//+----------------------------------------------+
//---   10   
#property indicator_type20   DRAW_COLOR_ARROW
//---     
#property indicator_color20 clrMagenta,clrGray,clrMediumSeaGreen
//---     5
#property indicator_width20  5
//---   
#property indicator_label20  "Signal Arrow 10"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame0=PERIOD_H1;           //   1
input ENUM_TIMEFRAMES TimeFrame1=PERIOD_H2;           //   2
input ENUM_TIMEFRAMES TimeFrame2=PERIOD_H3;           //   3
input ENUM_TIMEFRAMES TimeFrame3=PERIOD_H4;           //   4
input ENUM_TIMEFRAMES TimeFrame4=PERIOD_H6;           //   5
input ENUM_TIMEFRAMES TimeFrame5=PERIOD_H8;           //   6
input ENUM_TIMEFRAMES TimeFrame6=PERIOD_H12;          //   7
input ENUM_TIMEFRAMES TimeFrame7=PERIOD_D1;           //   8
input ENUM_TIMEFRAMES TimeFrame8=PERIOD_W1;           //   9
input ENUM_TIMEFRAMES TimeFrame9=PERIOD_MN1;          //   10
//----  Stochastic
input uint KPeriod=5;
input uint DPeriod=3;
input uint Slowing=3;
input ENUM_MA_METHOD MA_Method=MODE_SMA;
input ENUM_STO_PRICE Price_field=STO_LOWHIGH;
input int UpLevel=70;                                 //  
input int DnLevel=30;                                 //  
//+----------------------------------------------+
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+  
class CIndBuffers
  {
public:
   double            m_ArrBuffer[];
   double            m_ColorArrBuffer[];
   double            m_LineBuffer[];
   double            m_ColorLineBuffer[];
   int               m_Handle;
   ENUM_TIMEFRAMES   m_TimeFrame;
  };
//---   ,   
//---      
CIndBuffers Ind[INDTOTAL];
//+------------------------------------------------------------------+   
//| StochasticTrend_x10 indicator initialization function            | 
//+------------------------------------------------------------------+ 
bool IndInit(uint Number)
  {
//---     
   if(Ind[Number].m_TimeFrame<Period() && Ind[Number].m_TimeFrame!=PERIOD_CURRENT)
     {
      Print("IndInit(",Number,"):     StochasticTrend_x10       ");
      return(false);
     }
//----     
   Ind[Number].m_Handle=iStochastic(NULL,Ind[Number].m_TimeFrame,KPeriod,DPeriod,Slowing,MA_Method,Price_field);

   if(Ind[Number].m_Handle==INVALID_HANDLE)
     {
      Print("IndInit(",Number,"):      Stochastic");
      return(false);
     }
   uint BIndex=Number*4+0;
   uint PIndex=Number*2+0;
   InitTsIndBuffer(BIndex,PIndex,Ind[Number].m_LineBuffer,EMPTY_VALUE,min_rates_total);
   InitTsIndColorBuffer(BIndex+1,Ind[Number].m_ColorLineBuffer,min_rates_total);
   InitTsIndArrBuffer(BIndex+2,PIndex+1,Ind[Number].m_ArrBuffer,EMPTY_VALUE,min_rates_total);
   InitTsIndColorBuffer(BIndex+3,Ind[Number].m_ColorArrBuffer,min_rates_total);
//----   
   string tmf=GetStringTimeframe(Ind[Number].m_TimeFrame);
   PlotIndexSetString(PIndex+0,PLOT_LABEL,INDICATOR_NAME+"("+tmf+")");
   PlotIndexSetString(PIndex+1,PLOT_LABEL,INDICATOR_NAME+"Arr("+tmf+")");
//---  
   return(true);
  }
//+------------------------------------------------------------------+
//|                         |
//+------------------------------------------------------------------+  
void InitTsIndBuffer(uint Number,uint Plot,double &IndBuffer[],double Empty_Value,uint Draw_Begin)
  {
//---      
   SetIndexBuffer(Number,IndBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(Plot,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Plot,PLOT_EMPTY_VALUE,Empty_Value);
//---       
   ArraySetAsSeries(IndBuffer,true);
  }
//+------------------------------------------------------------------+
//|                         |
//+------------------------------------------------------------------+  
void InitTsIndArrBuffer(uint Number,uint Plot,double &IndBuffer[],double Empty_Value,uint Draw_Begin)
  {
//---      
   SetIndexBuffer(Number,IndBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(Plot,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Plot,PLOT_EMPTY_VALUE,Empty_Value);
//---    
   PlotIndexSetInteger(Plot,PLOT_ARROW,159);
//---       
   ArraySetAsSeries(IndBuffer,true);
  }
//+------------------------------------------------------------------+
//|                    |
//+------------------------------------------------------------------+  
void InitTsIndColorBuffer(uint Number,double &IndColorBuffer[],uint Draw_Begin)
  {
//---          
   SetIndexBuffer(Number,IndColorBuffer,INDICATOR_COLOR_INDEX);
//---       
   ArraySetAsSeries(IndColorBuffer,true);
  }
//+------------------------------------------------------------------+ 
//| IndOnCalculate                                                   | 
//+------------------------------------------------------------------+ 
bool IndOnCalculate(int Number,int Limit,const datetime &Time[],uint Rates_Total,uint Prev_Calculated)
  {
//---   
   int limit_;
//---       
   double Main[1];
   datetime Time_[1],Time0;
   static int LastCountBar[INDTOTAL];
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit_=Limit;
      LastCountBar[Number]=limit_;
     }
   else limit_=int(MathMin(LastCountBar[Number]+Limit,Rates_Total-2)); //      
//---    
   for(int bar=int(limit_); bar>=0 && !IsStopped(); bar--)
     {
      //---      
      Ind[Number].m_ArrBuffer[bar]=EMPTY_VALUE;
      Ind[Number].m_LineBuffer[bar]=Number+1.0;
      Ind[Number].m_ColorArrBuffer[bar]=1;
      Ind[Number].m_ColorLineBuffer[bar]=1;
      Time0=Time[bar];
      //---      
      if(CopyTime(Symbol(),Ind[Number].m_TimeFrame,Time0,1,Time_)<=0) return(false);
      //---
      if(Time0>=Time_[0] && Time[bar+1]<Time_[0])
        {
         LastCountBar[Number]=bar;
         //---      
         //----      
         if(CopyBuffer(Ind[Number].m_Handle,MAIN_LINE,Time0,1,Main)<=0) return(false);
         //---
         if(Main[0]>UpLevel)
           {
            Ind[Number].m_ColorLineBuffer[bar]=2;
            Ind[Number].m_ColorArrBuffer[bar]=2;
           }
         //---
         if(Main[0]<DnLevel)
           {
            Ind[Number].m_ColorLineBuffer[bar]=0;
            Ind[Number].m_ColorArrBuffer[bar]=0;
           }

         Ind[Number].m_ArrBuffer[bar]=Number+1.0;
        }
      else Ind[Number].m_ColorLineBuffer[bar]=Ind[Number].m_ColorLineBuffer[bar+1];
     }
//---        
   return(true);
  }
//+------------------------------------------------------------------+   
//| StochasticTrend_x10 indicator initialization function            | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//---     
   min_rates_total=int(KPeriod+DPeriod+Slowing)+1;
//---   
   Ind[0].m_TimeFrame=TimeFrame0;
   Ind[1].m_TimeFrame=TimeFrame1;
   Ind[2].m_TimeFrame=TimeFrame2;
   Ind[3].m_TimeFrame=TimeFrame3;
   Ind[4].m_TimeFrame=TimeFrame4;
   Ind[5].m_TimeFrame=TimeFrame5;
   Ind[6].m_TimeFrame=TimeFrame6;
   Ind[7].m_TimeFrame=TimeFrame7;
   Ind[8].m_TimeFrame=TimeFrame8;
   Ind[9].m_TimeFrame=TimeFrame9;
//---   
   for(int count=0; count<INDTOTAL; count++) if(!IndInit(count)) return(INIT_FAILED);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"MultiStochasticTrend_x10");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| StochasticTrend_x10 iteration function                           | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---   
   int limit;
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-min_rates_total-1; //      
   else limit=rates_total-prev_calculated; //       
//---         
   ArraySetAsSeries(time,true);
   for(int count=0; count<INDTOTAL; count++) if(!IndOnCalculate(count,limit,time,rates_total,prev_calculated)) return(RESET);
//---   
   return(rates_total);
  }
//+------------------------------------------------------------------+
