//+------------------------------------------------------------------+
//|                                                    BBflat_sw.mq5 | 
//|                                           Copyright  2008, Raff | 
//|                                                                  | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2008, Raff"
#property link ""
#property description ""
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---    3
#property indicator_buffers 3 
//---     
#property indicator_plots   3
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---     
#property indicator_type1   DRAW_LINE
//---        
#property indicator_color1 clrBlue
//---   -  
#property indicator_style1  STYLE_SOLID
//---     2
#property indicator_width1  2
//---   
#property indicator_label1  "Signal Line"
//+--------------------------------------------+
//|    BB   |
//+--------------------------------------------+
//---      
#property indicator_type2   DRAW_LINE
#property indicator_type3   DRAW_LINE
//---    
#property indicator_color2  clrRed
#property indicator_color3  clrRed
//---   -  
#property indicator_style2 STYLE_SOLID
#property indicator_style3 STYLE_SOLID
//---     1
#property indicator_width2  1
#property indicator_width3  1
//---    
#property indicator_label2  "+NSigma"
#property indicator_label3  "-NSigma"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_SOLID
//+-----------------------------------+
//|          |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//---    CXMA  CStdDeviation   SmoothAlgorithms.mqh
CXMA XMA1;
CStdDeviation STD;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simple Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method XMA_Method=MODE_SMA; //  
input int XLength=100;                   //                       
input int XPhase=15;                     //  
//--- XPhase:  JJMA    -100 ... +100,     ;
//--- XPhase:  VIDIA   CMO,  AMA    
input int BandsPeriod=100;               //   BB
input double BandsDeviation = 2.0;       // 
input Applied_price_ IPC=PRICE_CLOSE;    //  
input int Shift=0;                       //      
//+-----------------------------------+
//---   ,   
//---      
double ExtLineBuffer[];
//---   ,   
//---        
double ExtLineBuffer1[],ExtLineBuffer2[];
//---      
int min_rates_total,min_rates_;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---     
   min_rates_=XMA1.GetStartBars(XMA_Method,XLength,XPhase)+1;
   min_rates_total=min_rates_+BandsPeriod;
//---       
   XMA1.XMALengthCheck("XLength",XLength);
   XMA1.XMALengthCheck("BandsPeriod", BandsPeriod);
//---       
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//---      
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---      
   SetIndexBuffer(1,ExtLineBuffer1,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLineBuffer2,INDICATOR_DATA);
//---  ,      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//---      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---      
   string shortname;
   string Smooth=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"BBflat_sw(",XLength,", ",BandsPeriod,", ",Smooth,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(0);
//---       
   double price,xma,stdev;
//---        
   int first,bar;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);
      xma=XMA1.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength,price,bar,false);
      stdev=STD.StdDevSeries(min_rates_,prev_calculated,rates_total,BandsPeriod,BandsDeviation,price,xma,bar,false)/_Point;     
      ExtLineBuffer[bar]=(price-xma)/_Point;     
      ExtLineBuffer1[bar]=+stdev;
      ExtLineBuffer2[bar]=-stdev;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
