//+------------------------------------------------------------------+
//|                                                      SFX_TOR.mq5 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2007, MetaQuotes Software Corp."
//---    
#property link      "http://www.metaquotes.net"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 3
//---    
#property indicator_plots   3
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         
#property indicator_color1  clrLimeGreen
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  1
#property indicator_width1  1
//---    
#property indicator_label1  "ATR"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---         
#property indicator_color2  clrMagenta
//---   2 -  
#property indicator_style2  STYLE_SOLID
//---    2  1
#property indicator_width2  1
//---    
#property indicator_label2  "StdDev"
//+----------------------------------------------+
//|   StdDev MA      |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_LINE
//---    MA     
#property indicator_color3  clrDodgerBlue
//---   3 -  
#property indicator_style3  STYLE_SOLID
//---    3  1
#property indicator_width3  1
//---    
#property indicator_label3  "StdDev MA"
//+-----------------------------------------------+
//|                             |
//+-----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint   ATR_period=12;
input uint   Std_period=12;
input  ENUM_MA_METHOD   Std_method=MODE_EMA;
input ENUM_APPLIED_PRICE   Std_price=PRICE_CLOSE;
input int   MAPeriod=3;
input  ENUM_MA_METHOD   MAType=MODE_SMMA;
//+----------------------------------------------+
//---   ,   
//---      
double ATRBuffer[];
double StdBuffer[];
double MABuffer[];
//---      
int ATR_Handle,Std_Handle,MA_Handle;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---    ATR
   ATR_Handle=iATR(NULL,PERIOD_CURRENT,ATR_period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---    iStdDev
   Std_Handle=iStdDev(NULL,0,Std_period,0,Std_method,Std_price);
   if(Std_Handle==INVALID_HANDLE)
     {
      Print("      iStdDev");
      return(INIT_FAILED);
     }
//---    iMA
   MA_Handle=iMA(NULL,0,MAPeriod,0,MAType,Std_Handle);
   if(MA_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//---     
   min_rates_total=int(MathMax(ATR_period,Std_period+MAPeriod));
//---    ATRBuffer   
   SetIndexBuffer(0,ATRBuffer,INDICATOR_DATA);
//---       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---          
   ArraySetAsSeries(ATRBuffer,true);
//---    StdBuffer   
   SetIndexBuffer(1,StdBuffer,INDICATOR_DATA);
//---       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---          
   ArraySetAsSeries(StdBuffer,true);
//---    StdBuffer   
   SetIndexBuffer(2,MABuffer,INDICATOR_DATA);
//---       3  min_rates_total
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---          
   ArraySetAsSeries(MABuffer,true);
//---      
   string shortname="SFX_TOR";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(ATR_Handle)<rates_total
      || BarsCalculated(Std_Handle)<rates_total
      || BarsCalculated(MA_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//---    
   int to_copy;
//---    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      to_copy=rates_total;
     }
   else to_copy=rates_total-prev_calculated+1; //      
//---      
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATRBuffer)<=0) return(RESET);
   if(CopyBuffer(Std_Handle,0,0,to_copy,StdBuffer)<=0) return(RESET);
   if(CopyBuffer(MA_Handle,0,0,to_copy,MABuffer)<=0) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
