//+------------------------------------------------------------------+
//|                                                      ATRNorm.mq5 |
//|                                  Copyright  2012, Ivan Kornilov |
//|                                  excelf@gmail.com, skype: excelf |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2012, Ivan Kornilov"
//---  
#property link      "excelf@gmail.com"
//---   
#property version   "1.01"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|    ATRNorm       |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         
#property indicator_color1  clrRed
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  1
#property indicator_width1  1
//---    
#property indicator_label1  "ATRNorm"
//+----------------------------------------------+
//|    LeadATRNorm   |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---         
#property indicator_color2  clrBlue
//---   2 -  
#property indicator_style2  STYLE_SOLID
//---    2  1
#property indicator_width2  1
//---    
#property indicator_label2  "LeadATRNorm"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.25
#property indicator_level1 0.50
#property indicator_level1 0.75
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                       |
//+----------------------------------------------+
//#property indicator_minimum -1
//#property indicator_maximum 1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum IndType
  {
   ATR=0,           // ATR
   Volume_,         // Volume
   TrueRange,       // TrueRange
   TrueRangeVolume, // TrueRange Volume
   Log,             // Log
   stdDev           // stdDev
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//---    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint period=12;                              //  
input uint ma=12;                                  //  
input IndType ValueType=ATR;                       //   
input uint normLimit=24;                           //  
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  // 
input int Shift=0;                                 //       
//+----------------------------------------------+
//---   ,   
//---      
double AtrBuffer[];
double FlatBuffer[];
//---      
int Handle;
//---      
int min_rates_total;
//---   ,   
//---      
int Count[];
double SMABuffer[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//---
   int numb,Max1,Max2;
   static int count=1;
//---
   Max2=Size;
   Max1=Max2-1;
//---
   count--;
   if(count<0) count=Max1;
//---
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//---
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//---     
   min_rates_total=int(MathMax(period+ma+1,normLimit));
//---    iBearsPower
   if(ValueType==ATR)
     {
      Handle=iATR(NULL,0,int(period));
      if(Handle==INVALID_HANDLE) Print("     !");
     }
//---
   if(ValueType==stdDev)
     {
      Handle=iStdDev(NULL,0,int(period),0,MODE_SMA,PRICE_CLOSE);
      if(Handle==INVALID_HANDLE) Print("     !");
     }
//---       
   ArrayResize(Count,normLimit);
   ArrayResize(SMABuffer,normLimit);
   ArrayInitialize(Count,0.0);
   ArrayInitialize(SMABuffer,0.0);
//---      
   SetIndexBuffer(0,AtrBuffer,INDICATOR_DATA);
//---    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---      
   SetIndexBuffer(1,FlatBuffer,INDICATOR_DATA);
//---    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---      
   string shortname;
   StringConcatenate(shortname,"ATRNorm(",period,",",ma,",",normLimit," ",EnumToString(ValueType),")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(ValueType==ATR || ValueType==stdDev)if(BarsCalculated(Handle)<rates_total) return(RESET);
//---    
   int first,bar;
   double val;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=1;                   //      
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      val=getValue(ValueType,rates_total-1,high,low,close,tick_volume,volume,bar);
      //---
      if(ValueType!=ATR || ValueType!=stdDev)
         SMABuffer[Count[0]]=XMA1.XMASeries(period+1,prev_calculated,rates_total,MODE_SMA_,0,period,val,bar,false);
      else SMABuffer[Count[0]]=val;
      //---
      AtrBuffer[bar]=normValue(SMABuffer,normLimit,Count[0]);
      if(AtrBuffer[bar]==EMPTY_VALUE) return(RESET);
      //---
      FlatBuffer[bar]=XMA2.XMASeries(period+1+period+normLimit,prev_calculated,rates_total,MODE_SMA_,0,ma,AtrBuffer[bar],bar,false);
      if(bar<rates_total-1) Recount_ArrayZeroPos(Count,normLimit);
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+    
//| normValue()                                                      | 
//+------------------------------------------------------------------+
double normValue(double &buffer[],int count,int i)
  {
//---
   double max = buffer[ArrayMaximum(buffer,0,WHOLE_ARRAY)];
   double min = buffer[ArrayMinimum(buffer,0,WHOLE_ARRAY)];
   double value;
//---
   if(max-min == 0) value = 1;
   else value =(buffer[i] - min) /(max - min);
//---
   if(value>1) value=1;
   else if(value<0) value=0;
//---
   return(value);
  }
//+------------------------------------------------------------------+    
//| getValue                                                         | 
//+------------------------------------------------------------------+
double getValue(IndType valueType,int MaxBar,const double &High[],const double &Low[],
                const double &Close[],const long &TcVolume[],const long &Volume[],int shift)
  {
//---
   double Arr[1],value=0;
//---
   switch(valueType)
     {
      case ATR:
         //---        
         if(CopyBuffer(Handle,0,MaxBar-shift,1,Arr)<=0) return(EMPTY_VALUE);
         return(Arr[0]);
         //---
      case Volume_:
        {
         long vol;
         if(VolumeType==VOLUME_TICK) vol=TcVolume[shift];
         else                        vol=Volume[shift];
         return(double(vol));
        }
      //---
      case TrueRange:
         if(shift==1) value=High[shift]-Low[shift];
         else value=MathMax(High[shift],High[shift-1])-MathMin(Low[shift],Low[shift-1]);
         return(value);
         //---
      case TrueRangeVolume:
        {
         if(shift==1) value=High[shift]-Low[shift];
         else value=MathMax(High[shift],Close[shift-1])-MathMin(Low[shift],Close[shift-1]);
         long vol;
         if(VolumeType==VOLUME_TICK) vol=TcVolume[shift];
         else                        vol=Volume[shift];
         return(value/_Point*vol);
        }
      //---
      case Log:
         if(Close[shift-1]==0) value=0;
         else value=MathLog(MathMax(Close[shift-1],Close[shift])/MathMin(Close[shift-1],Close[shift]));
         return(value);
         //---
      case stdDev:
         //---        
         if(CopyBuffer(Handle,0,MaxBar-shift,1,Arr)<=0) return(EMPTY_VALUE);
         return(Arr[0]);
      default: return(0);
     }
//---
   return(0);
  }
//+------------------------------------------------------------------+
