//+------------------------------------------------------------------+
//|                                                          AML.mq5 |
//|                                                         andreybs |
//|                                               andreybs@yandex.ru |
//+------------------------------------------------------------------+
//---  
#property copyright "Adaptive Market Level"
//---  
#property link      "andreybs@yandex.ru"
//---   
#property version   "1.11"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 1
//---    
#property indicator_plots   1
//+----------------------------------------------+
//|    Cycle         |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---        DarkOrchid 
#property indicator_color1  clrDarkOrchid
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  3
#property indicator_width1  3
//---    
#property indicator_label1  "AML"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Fractal=6;
input int Lag=7;
input int Shift=0;    //      
//+----------------------------------------------+
//---   ,   
//---      
double AMLBuffer[];
double LagLagPoint;
//---      
int min_rates_total,size;
//---   ,   
//---      
int Count[];
double Smooth[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//---
   int numb,Max1,Max2;
   static int count=1;
//---
   Max2=Size;
   Max1=Max2-1;
//---
   count--;
   if(count<0) count=Max1;
//---
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//---
  }
//+------------------------------------------------------------------+
//|                          |
//+------------------------------------------------------------------+
double Range(int period,int start,const double &High[],const double &Low[])
  {
//---
   double max = High[ArrayMaximum(High,start,period)];
   double min = Low[ArrayMinimum(Low,start,period)];
//---
   return(max-min);
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//---     
   min_rates_total=(int)(Fractal+Lag);
//---  
   LagLagPoint=Lag*Lag*_Point;
   size=Lag+1;
//---       
   ArrayResize(Count,size);
   ArrayResize(Smooth,size);
//---   
   ArrayInitialize(Smooth,0.0);
   ArrayInitialize(Count,0.0);
//---      
   SetIndexBuffer(0,AMLBuffer,INDICATOR_DATA);
//---    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---       
   ArraySetAsSeries(AMLBuffer,true);
//---      
   string shortname;
   StringConcatenate(shortname,"AML(",Fractal,", ",Lag,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(0);
//---    
   int limit,bar;
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-min_rates_total-1; //      
   else limit=rates_total-prev_calculated; //      
//---         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(close,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      double R1 = Range(Fractal,bar,high,low)/Fractal;
      double R2 = Range(Fractal,bar+Fractal,high,low)/Fractal;
      double R3 = Range(2*Fractal,bar,high,low)/(2*Fractal);
      //---      
      double dim=0;
      if(R1+R2>0 && R3>0) dim=(MathLog(R1+R2)-MathLog(R3))*1.44269504088896;
      //--- 
      double alpha=MathExp(-Lag*(dim-1.0));
      alpha=MathMin(alpha,1.0);
      alpha=MathMax(alpha,0.01);
      //---
      double price=(high[bar]+low[bar]+2*open[bar]+2*close[bar])/6;
      Smooth[Count[0]]=alpha*price+(1.0-alpha)*Smooth[Count[1]];
      //---
      if(MathAbs(Smooth[Count[0]]-Smooth[Count[Lag]])>=LagLagPoint) AMLBuffer[bar]=Smooth[Count[0]];
      else AMLBuffer[bar]=AMLBuffer[bar+1];
      if(bar) Recount_ArrayZeroPos(Count,size);
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
