//+------------------------------------------------------------------+
//|                                                    AMA_SLOPE.mq5 |
//|                                        Copyright  2007, Kalenzo |
//|                                      bartlomiej.gorski@gmail.com | 
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2007, Kalenzo"
//---    
#property link      "bartlomiej.gorski@gmail.combartlomiej.gorski@gmail.com"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 1
//---    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---        - 
#property indicator_color1  clrBlueViolet
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  3
#property indicator_width1  3
//---    
#property indicator_label1  "AMA_SLOPE"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint ama_period=9;        //  AMA
input uint fast_ma_period=2;    //   
input uint slow_ma_period=30;   //   
input double G=2.0;             // ,     
input int AMAShift = 0;         //       
input double dK = 1.0;          //   
//+----------------------------------------------+
//---   ,   
//---      
double AMABuffer[];
//---       
double dSC,slowSC,fastSC;
int AMA_Handle,dAMA_Handle;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---   
   min_rates_total=int(ama_period+1);
//---    AMABuffer   
   SetIndexBuffer(0,AMABuffer,INDICATOR_DATA);
//---    1    ama_shift
   PlotIndexSetInteger(0,PLOT_SHIFT,AMAShift);
//---       1  1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---      
   string shortname;
   StringConcatenate(shortname,"AMA_SLOPE( ",ama_period,", ",fast_ma_period,", ",slow_ma_period," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---   
   slowSC = (2.0 / (slow_ma_period + 1));
   fastSC = (2.0 / (fast_ma_period + 1));
   dSC=fastSC-slowSC;
//---
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const int begin,          //     
                const double &price[])    //     
  {
//---       
   if(rates_total<min_rates_total+begin) return(0);
//---    
   int first,bar;
   double noise,AMA,signal,ER,ERSC,SSC,price0,price1;
   static double AMA_;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_total+begin+1; //      
      AMA_=price[first-1];
      AMA=AMA_;
      //---      begin ,      
      if(begin>0)
        {
         PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total+begin);
        }
     }
   else
     {
      first=prev_calculated-1; //      
      AMA=AMA_;
     }
//---     AMA
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //---
      noise=_Point/10000;
      for(int iii=0; iii<int(ama_period); iii++)
        {
         price0=price[bar-iii-0];
         price1=price[bar-iii-1];
         noise+=MathAbs(price0-price1);
        }
      //---
      price0=price[bar];
      price1=price[bar-ama_period];
      signal=MathAbs(price0-price1);
      ER=signal/noise;
      ERSC=ER*dSC;
      SSC=ERSC+slowSC;
      AMA=AMA+(MathPow(SSC,G)*(price0-AMA));
      //---       AMA
      AMABuffer[bar]=(AMA-AMA_)/_Point;
      if(bar<rates_total-1) AMA_=AMA;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
