//+------------------------------------------------------------------+
//|                                                        Aroon.mq5 |
//|                             Copyright  2011,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2011, Nikolay Kositsin"
//---    
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.01"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         
#property indicator_color1  clrLime
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  1
#property indicator_width1  1
//---    
#property indicator_label1  "BullsAroon"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---         
#property indicator_color2  clrRed
//---   2 -  
#property indicator_style2  STYLE_SOLID
//---    2  1
#property indicator_width2  1
//---    
#property indicator_label2  "BearsAroon"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 70.0
#property indicator_level2 50.0
#property indicator_level3 30.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int AroonPeriod= 9;  //   
input int AroonShift = 0;  //       
//+----------------------------------------------+
//---   ,   
//---      
double BullsAroonBuffer[];
double BearsAroonBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//---    BullsAroonBuffer   
   SetIndexBuffer(0,BullsAroonBuffer,INDICATOR_DATA);
//---    1    AroonShift
   PlotIndexSetInteger(0,PLOT_SHIFT,AroonShift);
//---       1  AroonPeriod
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,AroonPeriod);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"BearsAroon");
//---    BearsAroonBuffer   
   SetIndexBuffer(1,BearsAroonBuffer,INDICATOR_DATA);
//---    2    AroonShift
   PlotIndexSetInteger(1,PLOT_SHIFT,AroonShift);
//---       2  AroonPeriod
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,AroonPeriod);
//---      DataWindow
   PlotIndexSetString(1,PLOT_LABEL,"BullsAroon");
//---      
   string shortname;
   StringConcatenate(shortname,"Aroon(",AroonPeriod,", ",AroonShift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---
  }
//+------------------------------------------------------------------+
//| Searching index of the highest bar                               |
//+------------------------------------------------------------------+
int iHighest(const double &array[], //      
             int count,             //    (        ), 
             int startPos           //  (   )  ,      
             )
  {
//---
   int index=startPos;
//---     
   if(startPos<0)
     {
      Print("    iHighest, startPos = ",startPos);
      return(0);
     }
//---   startPos  
   if(startPos-count<0)
      count=startPos;
//---
   double max=array[startPos];
//---  
   for(int i=startPos; i>startPos-count; i--)
     {
      if(array[i]>max)
        {
         index=i;
         max=array[i];
        }
     }
//---    
   return(index);
  }
//+------------------------------------------------------------------+
//| Searching index of the lowest bar                                |
//+------------------------------------------------------------------+
int iLowest(const double &array[], //      
            int count,             //    (        ), 
            int startPos           //  (   )  ,      
            )
  {
//---
   int index=startPos;
//---     
   if(startPos<0)
     {
      Print("    iLowest, startPos = ",startPos);
      return(0);
     }
//---   startPos  
   if(startPos-count<0)
      count=startPos;
//---
   double min=array[startPos];
//---  
   for(int i=startPos; i>startPos-count; i--)
     {
      if(array[i]<min)
        {
         index=i;
         min=array[i];
        }
     }
//---    
   return(index);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<AroonPeriod-1) return(0);
//---    
   int first,bar;
   double BULLS,BEARS;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=AroonPeriod-1;       //      
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //---   
      BULLS = 100 - (bar - iHighest(high, AroonPeriod, bar) + 0.5) * 100 / AroonPeriod;
      BEARS = 100 - (bar - iLowest (low,  AroonPeriod, bar) + 0.5) * 100 / AroonPeriod;
      //---       
      BullsAroonBuffer[bar] = BULLS;
      BearsAroonBuffer[bar] = BEARS;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
