//+------------------------------------------------------------------+ 
//|                                            ForexOFFTrendSign.mq5 | 
//|                        Copyright  2006, rewritten by CrazyChart | 
//|                                                  http://viac.ru/ | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, rewritten by CrazyChart"
#property link "http://viac.ru/"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        Orchid 
#property indicator_color1  clrOrchid
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "ForexOFFTrendSign Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        LimeGreen 
#property indicator_color2  clrLimeGreen
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "ForexOFFTrendSign Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint    SSP = 7;         //   
input uint   KPer = 7;         //     
input double Kmax = 50.6;
input int   Shift=0;           //      
//+----------------------------------------------+
//---      
int  min_rates_total,KPer3;
//---   ,   
//---      
double SellBuffer[],BuyBuffer[];
//---      
int ATR_Handle;
//---   
int Count[];
double Value[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//---
   int numb,Max1,Max2;
   static int count=1;
//---
   Max2=Size;
   Max1=Max2-1;
//---
   count--;
   if(count<0) count=Max1;
//---
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//---
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---     
   min_rates_total=int(MathMax(SSP,KPer)+KPer);
   int ATR_Period=15;
   min_rates_total=int(MathMax(ATR_Period,min_rates_total))+3;
   KPer3=int(KPer+3);
//---       
   ArrayResize(Count,KPer3);
   ArrayResize(Value,KPer3);
   ArrayInitialize(Count,0);
   ArrayInitialize(Value,0.0);
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,93);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,93);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"ForexOFFTrendSign("+string(SSP)+")");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[])
  {
//---       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//---       
   double HH,LL,ATR[1];
//---   
   int limit;
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-int(MathMax(SSP,KPer))-1; //      
   else limit=rates_total-prev_calculated;        //       
//---         
   ArraySetAsSeries(High,true);
   ArraySetAsSeries(Low,true);
   ArraySetAsSeries(Time,true);
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      HH=High[ArrayMaximum(High,bar,SSP)];
      LL=Low[ArrayMinimum(Low,bar,SSP)];
      Value[Count[0]]=HH-(HH-LL)*Kmax/100;
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---      
      if(Value[Count[1]]<=Value[Count[KPer+1]] && Value[Count[0]]>Value[Count[KPer]])
        {
         //---       ATR[]
         if(CopyBuffer(ATR_Handle,0,Time[bar],1,ATR)<=0) return(RESET);
         BuyBuffer[bar]=Low[bar]-ATR[0]*3/8;
        }
      //---   
      if(Value[Count[1]]>=Value[Count[KPer+1]] && Value[Count[0]]<Value[Count[KPer]])
        {
         //---       ATR[]
         if(CopyBuffer(ATR_Handle,0,Time[bar],1,ATR)<=0) return(RESET);
         SellBuffer[bar]=High[bar]+ATR[0]*3/8;
        }
      //---        
      if(bar) Recount_ArrayZeroPos(Count,KPer3);
     }
//---    
   return(rates_total);
  }
//+------------------------------------------------------------------+
