//+---------------------------------------------------------------------+
//|                                                ColorJFatl_StDev.mq5 | 
//|                                 Copyright  2015, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "2015,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.01"
//---     
#property indicator_chart_window
//---        
#property indicator_buffers 6
//---     
#property indicator_plots   5
//---     
#property indicator_type1   DRAW_COLOR_LINE
//---      
#property indicator_color1  clrMagenta,clrGray,clrGold
//---   -  
#property indicator_style1  STYLE_SOLID
//---     2
#property indicator_width1  2
//---   
#property indicator_label1  "JFATL"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        
#property indicator_color2  clrRed
//---    2  2
#property indicator_width2  2
//---    
#property indicator_label2  "Dn_Signal 1"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_ARROW
//---        
#property indicator_color3  clrAqua
//---    3  2
#property indicator_width3  2
//---    
#property indicator_label3  "Up_Signal 1"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   4   
#property indicator_type4   DRAW_ARROW
//---        
#property indicator_color4  clrRed
//---    4  4
#property indicator_width4  4
//---    
#property indicator_label4  "Dn_Signal 2"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   5   
#property indicator_type5   DRAW_ARROW
//---        
#property indicator_color5  clrAqua
//---    5  4
#property indicator_width5  4
//---    
#property indicator_label5  "Up_Signal 2"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int JLength=5;                   //  JMA                    
input int JPhase=-100;                 //  JMA ,
//--- JPhase:    -100 ... +100,     ;
input Applied_price_ IPC=PRICE_CLOSE_; //  
input int FATLShift=0;                 //  FATL    
input int PriceShift=0;                //  FATL    
input double dK1=1.5;                  //  1   
input double dK2=2.5;                  //  2   
input uint std_period=9;               //   
input int Shift=0;                     //      
//+-----------------------------------+
//---         
int FATLPeriod=39;
//---   ,   
//---      
double ExtLineBuffer[],ColorExtLineBuffer[];
double BearsBuffer1[],BullsBuffer1[];
double BearsBuffer2[],BullsBuffer2[];
int start,fstart,FATLSize;
double dPriceShift,dXFatl[];;
//+------------------------------------------------+ 
//|      |
//+------------------------------------------------+ 
double dFATLTable[]=
  {
   +0.4360409450, +0.3658689069, +0.2460452079, +0.1104506886,
   -0.0054034585, -0.0760367731, -0.0933058722, -0.0670110374,
   -0.0190795053, +0.0259609206, +0.0502044896, +0.0477818607,
   +0.0249252327, -0.0047706151, -0.0272432537, -0.0338917071,
   -0.0244141482, -0.0055774838, +0.0128149838, +0.0226522218,
   +0.0208778257, +0.0100299086, -0.0036771622, -0.0136744850,
   -0.0160483392, -0.0108597376, -0.0016060704, +0.0069480557,
   +0.0110573605, +0.0095711419, +0.0040444064, -0.0023824623,
   -0.0067093714, -0.0072003400, -0.0047717710, +0.0005541115,
   +0.0007860160, +0.0130129076, +0.0040364019
  };
//+------------------------------------------------------------------+
//|   iPriceSeries()                                  |
//|   iPriceSeriesAlert()                             |
//|   CJJMA                                            |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh>  
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
int OnInit()
  {
//---      
   if(dK1>=dK2)
     {
      Print("       1  2   !");
      return(INIT_FAILED);
     }
//---   
   FATLSize=ArraySize(dFATLTable);
   start=FATLSize+30+int(std_period);
//---       
   ArrayResize(dXFatl,std_period);
//---      
   string shortname;
   StringConcatenate(shortname,"JFATL(",JLength," ,",JPhase,")");
//---    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//---       FATLShift
   PlotIndexSetInteger(0,PLOT_SHIFT,FATLShift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,start);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---    2  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---     ,     
   SetIndexBuffer(1,ColorExtLineBuffer,INDICATOR_COLOR_INDEX);
//---    BearsBuffer   
   SetIndexBuffer(2,BearsBuffer1,INDICATOR_DATA);
//---    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,start);
//---    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//---      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---    BullsBuffer   
   SetIndexBuffer(3,BullsBuffer1,INDICATOR_DATA);
//---    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,start);
//---    
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//---      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---    BearsBuffer   
   SetIndexBuffer(4,BearsBuffer2,INDICATOR_DATA);
//---    2  
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,start);
//---    
   PlotIndexSetInteger(3,PLOT_ARROW,159);
//---      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---    BullsBuffer   
   SetIndexBuffer(5,BullsBuffer2,INDICATOR_DATA);
//---    3  
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,start);
//---    
   PlotIndexSetInteger(4,PLOT_ARROW,159);
//---      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---    
   dPriceShift=_Point*PriceShift;
//---    CJJMA   JJMASeries_Cls.mqh
   CJJMA JMA;
//---       
   JMA.JJMALengthCheck("JLength", JLength);
   JMA.JJMAPhaseCheck("JPhase", JPhase);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<start) return(0);
//---    
   int first,bar,clr;
   double jfatl,FATL;
   double SMAdif,Sum,StDev,dstd,BEARS1,BULLS1,BEARS2,BULLS2,Filter1,Filter2;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=FATLPeriod-1; //      
      fstart=first;
     }
   else first=prev_calculated-1; //      
//---    CJJMA   JJMASeries_Cls.mqh
   static CJJMA JMA;
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //---    FATL
      FATL=0.0;
      for(int iii=0; iii<FATLSize; iii++) FATL+=dFATLTable[iii]*PriceSeries(IPC,bar-iii,open,low,high,close);
      //---    JJMASeries. 
      //---  Phase  Length      (Din = 0) 
      jfatl=JMA.JJMASeries(fstart,prev_calculated,rates_total,0,JPhase,JLength,FATL,bar,false);
      //---       FATL
      ExtLineBuffer[bar]=jfatl+dPriceShift;
     }
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first++;
//---     
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      clr=1;
      if(ExtLineBuffer[bar-1]<ExtLineBuffer[bar]) clr=2;
      if(ExtLineBuffer[bar-1]>ExtLineBuffer[bar]) clr=0;
      ColorExtLineBuffer[bar]=clr;
     }
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=start;
//---      
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //---        
      for(int iii=0; iii<int(std_period); iii++) dXFatl[iii]=ExtLineBuffer[bar-iii]-ExtLineBuffer[bar-iii-1];
      //---     
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=dXFatl[iii];
      SMAdif=Sum/std_period;
      //---       
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=MathPow(dXFatl[iii]-SMAdif,2);
      //---      StDev   
      StDev=MathSqrt(Sum/std_period);
      //---  
      dstd=NormalizeDouble(dXFatl[0],_Digits+2);
      Filter1=NormalizeDouble(dK1*StDev,_Digits+2);
      Filter2=NormalizeDouble(dK2*StDev,_Digits+2);
      BEARS1=EMPTY_VALUE;
      BULLS1=EMPTY_VALUE;
      BEARS2=EMPTY_VALUE;
      BULLS2=EMPTY_VALUE;
      jfatl=ExtLineBuffer[bar];
      //---   
      if(dstd<-Filter1 && dstd>=-Filter2) BEARS1=jfatl; //  
      if(dstd<-Filter2) BEARS2=jfatl; //  
      if(dstd>+Filter1 && dstd<=+Filter2) BULLS1=jfatl; //  
      if(dstd>+Filter2) BULLS2=jfatl; //  
      //---       
      BullsBuffer1[bar]=BULLS1;
      BearsBuffer1[bar]=BEARS1;
      BullsBuffer2[bar]=BULLS2;
      BearsBuffer2[bar]=BEARS2;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
