//+------------------------------------------------------------------+
//|                                        Interchange_Indicator.mq5 |
//|                                           Copyright 2015, MigVRN |
//|                                                    Miguzov@bk.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright 2015, MigVRN"
#property link      "https://login.mql5.com/ru/users/MigVRN"
#property version   "1.00"

#include <My_struct.mqh>
#include <Interchange.mqh>

#property indicator_chart_window
#property indicator_buffers 6
#property indicator_plots 3

#property indicator_label1  "Average"
#property indicator_type1   DRAW_COLOR_LINE
#property indicator_color1  clrBlue, clrBlueViolet
#property indicator_style1  STYLE_SOLID
#property indicator_width1  2

#property indicator_label2  "High"
#property indicator_type2   DRAW_COLOR_LINE
#property indicator_color2  clrViolet, clrAquamarine
#property indicator_style2  STYLE_SOLID
#property indicator_width2  2

#property indicator_label3  "Low"
#property indicator_type3   DRAW_COLOR_LINE
#property indicator_color3  clrRed, clrFireBrick
#property indicator_style3  STYLE_SOLID
#property indicator_width3  2

double         AverageBuffer[];
double         AverageColors[];

double         HighPriceBuffer[];
double         HighPriceColors[];

double         LowPriceBuffer[];
double         LowPriceColors[];

Indicator_data Ind_data;       
CInterchange Ind_buffer;     
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   SetIndexBuffer(0,AverageBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,AverageColors,INDICATOR_COLOR_INDEX);

   SetIndexBuffer(2,HighPriceBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,HighPriceColors,INDICATOR_COLOR_INDEX);

   SetIndexBuffer(4,LowPriceBuffer,INDICATOR_DATA);
   SetIndexBuffer(5,LowPriceColors,INDICATOR_COLOR_INDEX);

   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0);

   PlotIndexSetString(0,PLOT_LABEL,"Average");
   PlotIndexSetString(1,PLOT_LABEL,"High");
   PlotIndexSetString(2,PLOT_LABEL,"Low");

   IndicatorSetString(INDICATOR_SHORTNAME,"Test("+_Symbol+" "+EnumToString((ENUM_TIMEFRAMES)_Period)+")");

   Ind_buffer.SetPrefixNameForLoad(_Symbol+"_"+(string)_Period);
   Ind_buffer.GetDataStart(Ind_data);

   Ind_buffer.GiveNewData();

   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   Ind_buffer.OnEvent(id,lparam,dparam,sparam);

   if(Ind_buffer.GetDataFinish(Ind_data))
     {
      RefreshData();
      Ind_buffer.GiveNewData();
     }
  }
//+------------------------------------------------------------------+
//| Deinitialization function                                        |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   Ind_buffer.Destroy();
  }
//+-----------------------------------------------------+
//| Refresh data in indicator buffers
//+-----------------------------------------------------+
bool RefreshData()
  {
   int index=Bars(_Symbol,_Period)-1;
   if(index<SIZE_BUFFER_INDICATOR) return(false);

   ArrayInitialize(AverageBuffer,0);
   ArrayInitialize(HighPriceBuffer,0);
   ArrayInitialize(LowPriceBuffer,0);
   ArrayInitialize(AverageColors,0);
   ArrayInitialize(LowPriceColors,0);
   ArrayInitialize(HighPriceColors,0);

   for(int i=0; i<SIZE_BUFFER_INDICATOR; i++)
     {
      AverageBuffer[index-i]=Ind_data.AverageBuffer[i];
      HighPriceBuffer[index-i]= Ind_data.HighPriceBuffer[i];
      LowPriceBuffer[index-i] = Ind_data.LowPriceBuffer[i];
      AverageColors[index-i]=Ind_data.AverageColors[i];
      LowPriceColors[index-i]=Ind_data.LowPriceColors[i];
      HighPriceColors[index-i]=Ind_data.HighPriceColors[i];
     }

   return(true);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   return(rates_total);
  }
//+------------------------------------------------------------------+
