//+---------------------------------------------------------------------+
//|                                                      X2MA_StDev.mq5 | 
//|                                  Copyright  2011, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|       SmoothAlgorithms.mqh    |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.02"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 4
//---    
#property indicator_plots   3
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---      
#property indicator_type1   DRAW_COLOR_LINE
//---      
#property indicator_color1  clrGray,clrBlueViolet,clrMagenta
//---   -  
#property indicator_style1  STYLE_SOLID
//---     2
#property indicator_width1  2
//---   
#property indicator_label1  "X2MA"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        
#property indicator_color2  clrRed
//---    2  2
#property indicator_width2  2
//---    
#property indicator_label2  "Dn_Signal"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_ARROW
//---        
#property indicator_color3  clrLime
//---    3  2
#property indicator_width3  2
//---    
#property indicator_label3  "Up_Signal"
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//---    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simple Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method MA_Method1=MODE_SMA;    //     
input uint Length1=12;                      //                        
input int Phase1=15;                        //   
//--- Phase1:  JJMA    -100 ... +100,     ;
//--- Phase1:  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method2=MODE_JJMA;   //     
input uint Length2 = 5;                     //     
input int Phase2=15;                        //   
//--- Phase2:  JJMA    -100 ... +100,     ;
//--- Phase2:  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE;       //  
input double dK=2.0;                        //    
input uint std_period=9;                    //   
input int Shift=0;                          //      
input int PriceShift=0;                     //      
//+----------------------------------------------+
//---   ,   
//---      
double X2MABuffer[];
double ColorX2MABuffer[];
double BearsBuffer[];
double BullsBuffer[];
double dX2MA[];
//---      
double dPriceShift;
//---      
int min_rates_total,min_rates_1,min_rates_2;
//+------------------------------------------------------------------+   
//| X2MA indicator initialization function                           | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---     
   min_rates_1=XMA1.GetStartBars(MA_Method1,Length1,Phase1);
   min_rates_2=XMA2.GetStartBars(MA_Method2,Length2,Phase2);
   min_rates_total=min_rates_1+min_rates_2+1+int(std_period);
//---       
   XMA1.XMALengthCheck("Length1",Length1);
   XMA2.XMALengthCheck("Length2",Length2);
//---       
   XMA1.XMAPhaseCheck("Phase1",Phase1,MA_Method1);
   XMA2.XMAPhaseCheck("Phase2",Phase2,MA_Method2);
//---    
   dPriceShift=_Point*PriceShift;
//---       
   ArrayResize(dX2MA,std_period);
//---      
   SetIndexBuffer(0,X2MABuffer,INDICATOR_DATA);
//---     ,     
   SetIndexBuffer(1,ColorX2MABuffer,INDICATOR_COLOR_INDEX);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---    BearsBuffer[]   
   SetIndexBuffer(2,BearsBuffer,INDICATOR_DATA);
//---    2    std_shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---       2  std_period + 2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//---      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//---    BullsBuffer[]   
   SetIndexBuffer(3,BullsBuffer,INDICATOR_DATA);
//---    3    std_shift
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//---       3  std_period + 2
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//---    
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//---      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
//---      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(MA_Method1);
   string Smooth2=XMA1.GetString_MA_Method(MA_Method2);
   StringConcatenate(shortname,"X2MA(",Length1,", ",Length2,", ",Smooth1,", ",Smooth2,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---  
  }
//+------------------------------------------------------------------+ 
//| X2MA iteration function                                          | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(0);

//---       
   double price,x1xma,x2xma,SMAdif,Sum,StDev,dstd,BEARS,BULLS,Filter;
//---        
   int first,bar;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0;                   //      
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //---   PriceSeries     price
      price=PriceSeries(IPC,bar,open,low,high,close);
      //---    XMASeries. 
      //---     begin   min_rates_1 . .   XMA   
      x1xma = XMA1.XMASeries(0,prev_calculated,rates_total,MA_Method1,Phase1,Length1,price,bar,false);
      x2xma = XMA2.XMASeries(min_rates_1,prev_calculated,rates_total,MA_Method2, Phase2, Length2,x1xma,bar,false);
      X2MABuffer[bar]=x2xma+dPriceShift;
     }
//---    first
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total; //      
//---     
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      ColorX2MABuffer[bar]=0;
      if(X2MABuffer[bar-1]<X2MABuffer[bar]) ColorX2MABuffer[bar]=1;
      if(X2MABuffer[bar-1]>X2MABuffer[bar]) ColorX2MABuffer[bar]=2;
     }
//---      
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //---        
      for(int iii=0; iii<int(std_period); iii++) dX2MA[iii]=X2MABuffer[bar-iii-0]-X2MABuffer[bar-iii-1];
      //---     
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=dX2MA[iii];
      SMAdif=Sum/std_period;
      //---       
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=MathPow(dX2MA[iii]-SMAdif,2);
      //---      StDev   
      StDev=MathSqrt(Sum/std_period);
      //---  
      dstd=NormalizeDouble(dX2MA[0],_Digits+2);
      Filter=NormalizeDouble(dK*StDev,_Digits+2);
      BEARS=0;
      BULLS=0;
      //---   
      if(dstd<-Filter) BEARS=X2MABuffer[bar]; //  
      if(dstd>+Filter) BULLS=X2MABuffer[bar]; //  
      //---       
      BullsBuffer[bar]=BULLS;
      BearsBuffer[bar]=BEARS;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
