//+------------------------------------------------------------------+
//|                                                    3dButtons.mq5 |
//|                                           Copyright 2015, fyords |
//|                           https://login.mql5.com/ru/users/fyords |
//+------------------------------------------------------------------+
#property copyright "Copyright 2015, fyords"
#property link      "https://login.mql5.com/ru/users/fyords"
#property version   "1.01"
//+------------------------------------------------------------------+
//| Insert resources                                                 |
//+------------------------------------------------------------------+
#resource "img\\200_1.bmp"
#resource "img\\200_2.bmp"
#resource "img\\200_3.bmp"
#resource "img\\200_4.bmp"
#resource "img\\200_5.bmp"
#resource "img\\200_6.bmp"
//+------------------------------------------------------------------+
#include "Class.mqh"
//+------------------------------------------------------------------+
enum Adjust
  {
   UpperLeft,
   UpperRight,
   LowerLeft,
   LowerRight
  };
//+------------------------------------------------------------------+
//| Input property                                                   |
//+------------------------------------------------------------------+
input Adjust adj_corner=UpperLeft;     //Corner
//+------------------------------------------------------------------+
//| Global variables                                                 |
//+------------------------------------------------------------------+
CBtn *btn[];

int num_buttons;
//+------------------------------------------------------------------+
//| Initialization function                                          |
//+------------------------------------------------------------------+
int OnInit()
  {
   long wnd=ChartID();
   int sub_wnd=ChartWindowOnDropped();

   ArrayFree(btn);
   int n=0;
   num_buttons=0;

   for(int y=0;y<3;y++)
     {
      for(int x=0;x<3;x++)
        {
         ArrayResize(btn,n+1);
         btn[n]=new CBtn;
         btn[n].Create(wnd,sub_wnd,"3dButtons_"+(string)MathRand(),x*152+10,y*152+10,200,200);
         btn[n].Resources("img\\200_1.bmp","img\\200_2.bmp","img\\200_3.bmp","img\\200_4.bmp","img\\200_5.bmp","img\\200_6.bmp");
         btn[n].AddText(80,80,"Arial",25,clrWhite,"Button"+(string)(n+1));
         switch(adj_corner)
           {
            case UpperLeft:
               btn[n].SetAnchor(ANCHOR_LEFT_UPPER);
               btn[n].SetCorner(CORNER_LEFT_UPPER);
               break;
            case UpperRight:
               btn[n].SetAnchor(ANCHOR_RIGHT_UPPER);
               btn[n].SetCorner(CORNER_RIGHT_UPPER);
               break;
            case LowerLeft:
               btn[n].SetAnchor(ANCHOR_LEFT_LOWER);
               btn[n].SetCorner(CORNER_LEFT_LOWER);
               break;
            case LowerRight:
               btn[n].SetAnchor(ANCHOR_RIGHT_LOWER);
               btn[n].SetCorner(CORNER_RIGHT_LOWER);
               break;
           }
         btn[n].Paint();
         n++;
        }
     }
   ChartRedraw();

   num_buttons=ArraySize(btn);

   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Deinitialization function                                        |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   for(int i=0;i<num_buttons;i++) delete btn[i];
   ArrayFree(btn);
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   for(int i=0;i<num_buttons;i++) btn[i].Event(id,lparam,dparam,sparam);
  }
//+------------------------------------------------------------------+
