//+------------------------------------------------------------------+ 
//|                                              Trinity-Impulse.mq5 | 
//|                           Copyright  2010, basisforex@gmail.com | 
//|                                             basisforex@gmail.com | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2010, basisforex@gmail.com"
#property link "basisforex@gmail.com"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window 
//---   
#property indicator_buffers 1 
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---     
#property indicator_type1   DRAW_LINE
//---       Orchid 
#property indicator_color1 clrOrchid
//---   -  
#property indicator_style1  STYLE_SOLID
//---     1
#property indicator_width1  1
//---   
#property indicator_label1  "Trinity-Impulse"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET  0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int nPeriod= 5;                           //  
input int nLevel= 34;                           //  
input  ENUM_MA_METHOD nType=MODE_LWMA;          //  
input ENUM_APPLIED_PRICE nPrice=PRICE_WEIGHTED; // 
input ENUM_APPLIED_VOLUME nVolume=VOLUME_TICK;  //  
//+-----------------------------------+
//---   ,   
//---      
double ExtLineBuffer[];
//---      
int min_rates_total;
//---      
int CCI_Handle,Force_Handle;
//+------------------------------------------------------------------+    
//| Trinity-Impulse indicator initialization function                | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=nPeriod;
//---    iCCI
   CCI_Handle=iCCI(NULL,0,nPeriod,nPrice);
   if(CCI_Handle==INVALID_HANDLE) 
     {
      Print("     iCCI");
      return(INIT_FAILED);
     }
//---    iForce
   Force_Handle=iForce(NULL,0,nPeriod,nType,nVolume);
   if(Force_Handle==INVALID_HANDLE) 
     {
      Print("     iForce");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(ExtLineBuffer,true);
//---      
   string shortname;
   StringConcatenate(shortname,"Trinity-Impulse(",nPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Trinity-Impulse iteration function                               | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(CCI_Handle)<rates_total
      || BarsCalculated(Force_Handle)<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//---   
   int to_copy,limit,bar;
   double CCI[],FORCE[];
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-2; //    
   else limit=rates_total-prev_calculated; //      
//---         
   ArraySetAsSeries(CCI,true);
   ArraySetAsSeries(FORCE,true);
   to_copy=limit+1;
//---      
   if(CopyBuffer(CCI_Handle,0,0,to_copy,CCI)<=0) return(RESET);
   if(CopyBuffer(Force_Handle,0,0,to_copy,FORCE)<=0) return(RESET);
//---    
   for(bar=limit; bar>=0; bar--)
     {
      if(CCI[bar]*FORCE[bar]>=nLevel)
        {
         if(CCI[bar]>0 && FORCE[bar]>0) ExtLineBuffer[bar]=1;
         if(CCI[bar]<0 && FORCE[bar]<0) ExtLineBuffer[bar]=-1;
        }
      else ExtLineBuffer[bar]=0;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
