//+------------------------------------------------------------------+
//|                                                  TimeControl.mqh |
//|                                     Copyright 2015, Martin Zivny |
//|                                              http://www.zivak.eu |
//+------------------------------------------------------------------+
#property copyright "Copyright 2015, Martin Zivny"
#property link      "http://www.zivak.eu"
#property version   "1.00"
#property strict
//+------------------------------------------------------------------+
//|  CTimeControl class                                              |
//+------------------------------------------------------------------+

class CTimeControl
  {
private:
      bool  m_arrDayEnabled[7];
      int   m_arrStartHour[7];
      double   m_arrStartMinute[7];
      int   m_arrStopHour[7];
      double   m_arrStopMinute[7];
      
public:
      CTimeControl();
      CTimeControl(
            bool  bSunday,
            bool  bMonday,
            bool  bTuesday,
            bool  bWednesday,
            bool  bThursday,
            bool  bFriday,
            bool  bSaturday
      );
       CTimeControl( bool &bDay[7],
                     int &iStartHour[7],
                     double &dStartMinute[7],
                     int &iStopHour[7],
                     double &dStopMinute[7]            
      );
      ~CTimeControl();

//+------------------------------------------------------------------+
//| Get Day Value                                                    |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//+------------------------------------------------------------------+
      bool  GetDay(int iDayIndex) { return m_arrDayEnabled[iDayIndex]; };
//+------------------------------------------------------------------+
//| Set Day Value                                                    |
//| parameter: bEnable - true - enable, false - disable              |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//+------------------------------------------------------------------+
      void  SetDay(int iDayIndex, bool bEnable) { m_arrDayEnabled[iDayIndex] = bEnable; };
//+------------------------------------------------------------------+
//| Enable Day - set true                                            |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//+------------------------------------------------------------------+
      void  EnableDay(int iDayIndex){ m_arrDayEnabled[iDayIndex] = true; };
//+------------------------------------------------------------------+
//| Disable Day - set false                                          |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//+------------------------------------------------------------------+
      void  DisableDay(int iDayIndex) { m_arrDayEnabled[iDayIndex] = false; };
//+------------------------------------------------------------------+
//| Get Monday Value                                                 |
//+------------------------------------------------------------------+
      bool  GetMonday() { return m_arrDayEnabled[MONDAY]; };
//+------------------------------------------------------------------+
//| Set Monday Value                                                 |
//| parameter: bEnable - true - enable, false - disable              |
//+------------------------------------------------------------------+
      void  SetMonday(bool bEnable) { m_arrDayEnabled[MONDAY] = bEnable; };
//+------------------------------------------------------------------+
//| Enable Monday - set true                                         |
//+------------------------------------------------------------------+
      void  EnableMonday(){ m_arrDayEnabled[MONDAY] = true; };
//+------------------------------------------------------------------+
//| Disable Value - set false                                        |
//+------------------------------------------------------------------+
      void  DisableMonday() { m_arrDayEnabled[MONDAY] = false; };
//+------------------------------------------------------------------+
//| Get Tuesday Value                                                |
//+------------------------------------------------------------------+
      bool  GetTuesday() { return m_arrDayEnabled[TUESDAY]; };
//+------------------------------------------------------------------+
//| Set Tuesday Value                                                |
//| parameter: bEnable - true - enable, false - disable              |
//+------------------------------------------------------------------+
      void  SetTuesday(bool bEnable) { m_arrDayEnabled[TUESDAY] = bEnable; };
//+------------------------------------------------------------------+
//| Enable Tuesday - set true                                        |
//+------------------------------------------------------------------+
      void  EnableTuesday(){ m_arrDayEnabled[TUESDAY] = true; };
//+------------------------------------------------------------------+
//| Disable Value - set false                                        |
//+------------------------------------------------------------------+
      void  DisableTuesday() { m_arrDayEnabled[TUESDAY] = false; };
//+------------------------------------------------------------------+
//| Get Wednesday Value                                              |
//+------------------------------------------------------------------+
      bool  GetWednesday() { return m_arrDayEnabled[WEDNESDAY]; };
//+------------------------------------------------------------------+
//| Set Wednesday Value                                              |
//| parameter: bEnable - true - enable, false - disable              |
//+------------------------------------------------------------------+
      void  SetWednesday(bool bEnable) { m_arrDayEnabled[WEDNESDAY] = bEnable; };
//+------------------------------------------------------------------+
//| Enable Wednesday - set true                                      |
//+------------------------------------------------------------------+
      void  EnableWednesday(){ m_arrDayEnabled[WEDNESDAY] = true; };
//+------------------------------------------------------------------+
//| Disable Value - set false                                        |
//+------------------------------------------------------------------+
      void  DisableWednesday() { m_arrDayEnabled[WEDNESDAY] = false; };
//+------------------------------------------------------------------+
//| Get Thursday Value                                               |
//+------------------------------------------------------------------+
      bool  GetThursday() { return m_arrDayEnabled[THURSDAY]; };
//+------------------------------------------------------------------+
//| Set Thursday Value                                               |
//| parameter: bEnable - true - enable, false - disable              |
//+------------------------------------------------------------------+
      void  SetThursday(bool bEnable) { m_arrDayEnabled[THURSDAY] = bEnable; };
//+------------------------------------------------------------------+
//| Enable Thursday - set true                                       |
//+------------------------------------------------------------------+
      void  EnableThursday(){ m_arrDayEnabled[THURSDAY] = true; };
//+------------------------------------------------------------------+
//| Disable Value - set false                                        |
//+------------------------------------------------------------------+
      void  DisableThursday() { m_arrDayEnabled[THURSDAY] = false; };
//+------------------------------------------------------------------+
//| Get Friday Value                                                 |
//+------------------------------------------------------------------+
      bool  GetFriday() { return m_arrDayEnabled[FRIDAY]; };
//+------------------------------------------------------------------+
//| Set Friday Value                                                 |
//| parameter: bEnable - true - enable, false - disable              |
//+------------------------------------------------------------------+
      void  SetFriday(bool bEnable) { m_arrDayEnabled[FRIDAY] = bEnable; };
//+------------------------------------------------------------------+
//| Enable Friday - set true                                         |
//+------------------------------------------------------------------+
      void  EnableFriday(){ m_arrDayEnabled[FRIDAY] = true; };
//+------------------------------------------------------------------+
//| Disable Value - set false                                        |
//+------------------------------------------------------------------+
      void  DisableFriday() { m_arrDayEnabled[FRIDAY] = false; };
//+------------------------------------------------------------------+
//| Get Saturday Value                                               |
//+------------------------------------------------------------------+
      bool  GetSaturday() { return m_arrDayEnabled[SATURDAY]; };
//+------------------------------------------------------------------+
//| Set Saturday Value                                               |
//| parameter: bEnable - true - enable, false - disable              |
//+------------------------------------------------------------------+
      void  SetSaturday(bool bEnable) { m_arrDayEnabled[SATURDAY] = bEnable; };
//+------------------------------------------------------------------+
//| Enable Saturday - set true                                       |
//+------------------------------------------------------------------+
      void  EnableSaturday(){ m_arrDayEnabled[SATURDAY] = true; };
//+------------------------------------------------------------------+
//| Disable Value - set false                                        |
//+------------------------------------------------------------------+
      void  DisableSaturday() { m_arrDayEnabled[SATURDAY] = false; };
//+------------------------------------------------------------------+
//| Get Sunday Value                                                 |
//+------------------------------------------------------------------+
      bool  GetSunday() { return m_arrDayEnabled[SUNDAY]; };
//+------------------------------------------------------------------+
//| Set Sunday Value                                                 |
//| parameter: bEnable - true - enable, false - disable              |
//+------------------------------------------------------------------+
      void  SetSunday(bool bEnable) { m_arrDayEnabled[SUNDAY] = bEnable; };
//+------------------------------------------------------------------+
//| Enable Sunday - set true                                         |
//+------------------------------------------------------------------+
      void  EnableSunday(){ m_arrDayEnabled[SUNDAY] = true; };
//+------------------------------------------------------------------+
//| Disable Value - set false                                        |
//+------------------------------------------------------------------+
      void  DisableSunday() { m_arrDayEnabled[SUNDAY] = false; };
//+------------------------------------------------------------------+
//| Get StartHour Value                                              |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//+------------------------------------------------------------------+
      int  GetStartHour(int iDayIndex) { return m_arrStartHour[iDayIndex]; };
//+------------------------------------------------------------------+
//| Set StartHour Value                                              |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//| parameter: int Hour                                              |
//+------------------------------------------------------------------+
      void  SetStartHour(int iDayIndex, int iHour) { m_arrStartHour[iDayIndex] = iHour; };
//+------------------------------------------------------------------+
//| Get StartMinute Value                                            |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//+------------------------------------------------------------------+
      double  GetStartMinute(int iDayIndex) { return m_arrStartMinute[iDayIndex]; };
//+------------------------------------------------------------------+
//| Set StartMinute Value                                            |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//| parameter: double Minute                                            |
//+------------------------------------------------------------------+
      void  SetStartMinute(int iDayIndex, double dMinute) { m_arrStartMinute[iDayIndex] = dMinute; };
//+------------------------------------------------------------------+
//| Get StopHour Value                                               |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//+------------------------------------------------------------------+
      int  GetStopHour(int iDayIndex) { return m_arrStopHour[iDayIndex]; };
//+------------------------------------------------------------------+
//| Set StopHour Value                                               |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//| parameter: int Hour                                              |
//+------------------------------------------------------------------+
      void  SetStopHour(int iDayIndex, int iHour) { m_arrStopHour[iDayIndex] = iHour; };
//+------------------------------------------------------------------+
//| Get StopMinute Value                                             |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//+------------------------------------------------------------------+
      double  GetStopMinute(int iDayIndex) { return m_arrStopMinute[iDayIndex]; };
//+------------------------------------------------------------------+
//| Set StopMinute Value                                             |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//| parameter: double Minute                                         |
//+------------------------------------------------------------------+
      void  SetStopMinute(int iDayIndex, double dMinute) { m_arrStopMinute[iDayIndex] = dMinute; };
      
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+                    
      void GetTradingDays(bool& arrDays[]);
      void GetTradingTime(int iDayIndex, int& iStartHour, double& dStartMinute, int& iStopHour, double& dStopMinute);
      
      bool IsTradingTime();
      bool IsTradingTime(datetime dt);
  };
//+------------------------------------------------------------------+
//|  default constructor - enable all week trade                     |
//+------------------------------------------------------------------+
CTimeControl::CTimeControl()
{
      for ( int i = 0; i <=6; i++ )
      {
            m_arrDayEnabled[i] = true;
            m_arrStartHour[i] = 0;
            m_arrStartMinute[i] = 0;
            m_arrStopHour[i] = 23;
            m_arrStopMinute[i] = 59;
      }
}
//+------------------------------------------------------------------+
//| constructor that you can enable days fo trading                  |
//+------------------------------------------------------------------+
CTimeControl::CTimeControl(bool bSunday,bool bMonday,bool bTuesday,bool bWednesday,bool bThursday,bool bFriday,bool bSaturday)
{
      m_arrDayEnabled[SUNDAY] = bSunday;
      m_arrDayEnabled[MONDAY] = bMonday;
      m_arrDayEnabled[TUESDAY] = bTuesday;
      m_arrDayEnabled[WEDNESDAY] = bWednesday;
      m_arrDayEnabled[THURSDAY] = bThursday;
      m_arrDayEnabled[FRIDAY] = bFriday;
      m_arrDayEnabled[SATURDAY] = bSaturday;
      for ( int i = 0; i <=6; i++ )
      {
            m_arrStartHour[i] = 0;
            m_arrStartMinute[i] = 0;
            m_arrStopHour[i] = 23;
            m_arrStopMinute[i] = 59;
      }
}

//+------------------------------------------------------------------+
//| constructor with all settings                                    |
//+------------------------------------------------------------------+
CTimeControl::CTimeControl(bool& bDay[7],int& iStartHour[7],double& dStartMinute[7],int& iStopHour[7],double& dStopMinute[7])
{
      ArrayCopy(m_arrDayEnabled,bDay,0,0,WHOLE_ARRAY);
      ArrayCopy(m_arrStartHour,iStartHour,0,0,WHOLE_ARRAY);      
      ArrayCopy(m_arrStartMinute,dStartMinute,0,0,WHOLE_ARRAY);
      ArrayCopy(m_arrStopHour,iStopHour,0,0,WHOLE_ARRAY);
      ArrayCopy(m_arrStopMinute,dStopMinute,0,0,WHOLE_ARRAY);     
}

//+------------------------------------------------------------------+
//|  default destructor                                              |
//+------------------------------------------------------------------+
CTimeControl::~CTimeControl()
{
}
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| fill array with trading days settings                            |
//+------------------------------------------------------------------+
void CTimeControl::GetTradingDays(bool& arrDays[7])
{
      ArrayCopy(arrDays,m_arrDayEnabled,0,0,WHOLE_ARRAY);
}  
//+------------------------------------------------------------------+
//| get trading time at specified day                                |
//| parameter: iDayIndex - ENUM_DAY_OF_WEEK                          |
//| parameter: iStartHour - trading start hour at specified day      |
//| parameter: dStartMinute - trading start minute at specified day  |
//| parameter: iStopHour - trading stop hour at specified day        |
//| parameter: dStopMinute - trading stop minute at specified day    |
//+------------------------------------------------------------------+
void CTimeControl::GetTradingTime(int iDayIndex, int& iStartHour, double& dStartMinute, int& iStopHour, double& dStopMinute)
{
      iStartHour = m_arrStartHour[iDayIndex];
      dStartMinute = m_arrStartMinute[iDayIndex];
      iStopHour = m_arrStopHour[iDayIndex];
      dStopMinute = m_arrStopMinute[iDayIndex];
}

//+------------------------------------------------------------------+
//| Is trading time at current server time enabled                   |
//+------------------------------------------------------------------+
bool CTimeControl::IsTradingTime()
{
      return IsTradingTime(TimeCurrent());
}
//+------------------------------------------------------------------+
//| Is trading time enabled                                          |
//| parameter: dt - datetime for check                               |
//+------------------------------------------------------------------+
bool CTimeControl::IsTradingTime(datetime dt)
{
      bool  arrDays[];
      GetTradingDays(arrDays);
      int   dtDay = TimeDayOfWeek(dt);
      if ( arrDays[dtDay] == false )
      { // this day is closed
            return false;
      }
      
      int dtHour = TimeHour(dt);
      double dtMinute = TimeMinute(dt);
      
      double Cur_time=dtHour + dtMinute/100;                                  // Current time
      double Start_time=m_arrStartHour[dtDay] + m_arrStartMinute[dtDay]/100;  // Start time
      double Stop_time=m_arrStopHour[dtDay] + m_arrStopMinute[dtDay]/100;     // Stop time
      
      if ( Start_time >= Stop_time )
      {
            Print("WRONG Start and Stop time settings for day!!! Trading disabled!!");
            return false;
      }
      
      if ( Cur_time < Start_time || Cur_time > Stop_time )
      { // time is out of range
            return false;
      }
            
      return true;
}  