//+------------------------------------------------------------------+
//|                                           Time Filter Libary.mq4 |
//|                        Copyright 2014, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property library
#property copyright "Copyright 2014, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property strict
//+------------------------------------------------------------------+
//inStart="00:00", time to start trade
//inEnd="23:59", time to end the trade
//+------------------------------------------------------------------+
//| sTimeFilter                                                      |
//| the funciton return true/false                                   |
//| if the current time is in the time trade                         |
//+------------------------------------------------------------------+
bool sTimeFilter(string inStart,string inEnd,string inString=":")
  {
   bool Result=true;
   int TimeHourStart,TimeMinuteStart,TimeHourEnd,TimeMinuteEnd;
   static datetime TimeStart,TimeEnd;
//---
   sInputTimeConvert(TimeHourStart,TimeMinuteStart,inStart,inString);
   sInputTimeConvert(TimeHourEnd,TimeMinuteEnd,inEnd,inString);
   TimeStart=StrToTime(IntegerToString(TimeHourStart)+":"+IntegerToString(TimeMinuteStart));
   TimeEnd=StrToTime(IntegerToString(TimeHourEnd)+":"+IntegerToString(TimeMinuteEnd));
//---
   if((TimeStart<=TimeEnd) && ((TimeCurrent()<TimeStart) || (TimeCurrent()>TimeEnd))) Result=false;
   if((TimeStart>TimeEnd) && (TimeCurrent()<TimeStart) && (TimeCurrent()>TimeEnd)) Result=false;
//---
   return(Result);
  }
//+------------------------------------------------------------------+
//| sInputTimeConvert                                                |
//+------------------------------------------------------------------+
int sInputTimeConvert(int &inHour,int &inMinute,string inInput,string inString=":")
  {
   int PS;
//---
   PS=StringFind(inInput,inString,0);
   inMinute=(int)StrToDouble(StringSubstr(inInput,PS+1,StringLen(inInput)-PS));
   inHour=(int)StrToDouble(StringSubstr(inInput,0,PS));
//---
   return(PS);
  }
//+------------------------------------------------------------------+
