//+------------------------------------------------------------------+
//|                                            SendAdvancedEmail.mq4 |
//|                                 Copyright 2014, Dorian Ocsovszki |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright 2014, Dorian Ocsovszki"
#property link      "http://ocsovszki-dorian.blogspot.co.uk/2014/05/sendextendedemail-dll-function-for.html"
#property version   "1.00"
#property strict
#property indicator_chart_window

#import "SendAdvancedEmail.dll"
   void SendAdvancedEmail(string MailFrom, string MailFromName, string MailTo, string MailCC, string MailSubject, string MailBodyContent, string MailBodyTemplate, string MailPriority, string MailAttachmentPath, string MailAttachmentName, string SMTPServer, int SMTPPort, bool SMTPEnableSSL, int SMTPTimeout, string SMTPUsername, string SMTPPassword);
#import

input string Separator1 = NULL; //=== SCREENSHOT SETTINGS ===
input string PathToScreenshots = "C:\\DATA\\%MT4DIR%\\MQL4\\Files\\"; // Path to Screenshots ( %MT4DIR%\MQL4\Files )
input int SCWidth = 1920; // Screenshot Width
input int SCHeight = 1080; // Screenshot Height

input string Separator2 = NULL; //=== MAIL SETTINGS ===
input string MailFrom = "";   // FROM:
input string MailFromName = "MT4 Advanced eMail Notifier"; // FROM NAME:
input string MailTo = "";  // TO:
input string MailCC = "";  // CC: (Mail1;Mail2;MailN ...)

input string Separator3 = NULL; //=== SMTP SETTINGS ===
input string SMTPServer = "";
input int SMTPPort = 587;
input string SMTPUsername = "";
input string SMTPPassword = "";

int SMTPTimeout = 10000;
bool SMTPEnableSSL = true;
string MailSubject = "MT4 Notifier";
string MailBody = "MT4 Notifier MailBody";
string MailAttachmentPath = NULL;
string MailAttachmentName = NULL;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping

   string SCFileNameVer1 = StringConcatenate(Symbol(), "_Period", Period(), "_", TimeYear(TimeLocal()), "-", TimeMonth(TimeLocal()), "-", TimeDay(TimeLocal()), "_", PadString(DoubleToStr(TimeHour(TimeLocal()),0),"0",2), "-", PadString(DoubleToStr(TimeMinute(TimeLocal()),0),"0",2), "-", PadString(DoubleToStr(TimeSeconds(TimeLocal()),0),"0",2), ".gif" );

   if (ShootScreenShot(SCFileNameVer1)) {
      SendAdvancedEmailSimple("[FOREX] New Order Opened", "2014.05.18 13:38:15.738	OrderHistoryTest GBPNZD,M15: #40320001 2014.05.08 18:21:20 buy limit 2.00 GBPNZD 1.92168 0.00000 0.00000 2014.05.15 19:40:55 1.94523 0.00 0.00 0.00 cancelled 0", "C:\\DATA\\XMMT4-GBPNZD\\MQL4\\Libraries\\MailBody.html", "Normal", PathToScreenshots + SCFileNameVer1, SCFileNameVer1);
   } else {
      Print("ERROR: Screenshot failed. Email event cancelled.");
   }
   
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+


void SendAdvancedEmailSimple(string fMailSubject, string fMailBodyContent, string fMailBodyTemplate, string fMailPriority = "Normal", string fMailAttachmentPath = NULL, string fMailAttachmentName = NULL)
{
   SendAdvancedEmail(MailFrom, MailFromName, MailTo, MailCC, fMailSubject, fMailBodyContent, fMailBodyTemplate, fMailPriority, fMailAttachmentPath, fMailAttachmentName, SMTPServer, SMTPPort, SMTPEnableSSL, SMTPTimeout, SMTPUsername, SMTPPassword);
}

bool ShootScreenShot(string SCFileName) 
{
   bool status = WindowScreenShot(SCFileName,SCWidth,SCHeight,-1,-1,-1);
   return (status);
}

string PadString(string toBePadded, string paddingChar, int paddingLength)
{
   while(StringLen(toBePadded) <  paddingLength)
   {
      toBePadded = StringConcatenate(paddingChar,toBePadded);
   }
   return (toBePadded);
}