//+---------------------------------------------------------------------+
//|                                                         XVolume.mq5 |
//|                                 Copyright  2012, Khlystov Vladimir |
//|                                            http://cmillion.narod.ru |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2012, cmillion@narod.ru"
#property link      "http://cmillion.narod.ru" 
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---    3
#property indicator_buffers 3 
//---     
#property indicator_plots   2
//+-----------------------------------+
//|    1  |
//+-----------------------------------+
//---      
#property indicator_type1   DRAW_COLOR_HISTOGRAM
//---     
#property indicator_color1 clrGray,clrDeepSkyBlue
//---   -  
#property indicator_style1  STYLE_SOLID
//---     2
#property indicator_width1  2
//---   
#property indicator_label1  "Volume"
//+-----------------------------------+
//|    2  |
//+-----------------------------------+
//---     
#property indicator_type2   DRAW_LINE
//---       Red 
#property indicator_color2 clrRed
//---   -  
#property indicator_style2  STYLE_SOLID
//---     2
#property indicator_width2  2
//---   
#property indicator_label2  "XVolume"
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//---    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  // 
input Smooth_Method XMA_Method=MODE_SMA;           //  
input int XLength=12;                              //                      
input int XPhase=15;                               //  
//--- XPhase:  JJMA    -100 ... +100,     ;
//--- XPhase:  VIDIA   CMO,  AMA    
input int Shift=0;                                 //      
//+-----------------------------------+
//---   ,         
double IndBuffer1[],ColorIndBuffer1[],IndBuffer2[];
//---      
int min_rates_total;
//+------------------------------------------------------------------+   
//| XVolume indicator initialization function                        | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---     
   min_rates_total=XMA1.GetStartBars(XMA_Method,XLength,XPhase);
//---       
   XMA1.XMALengthCheck("XLength",XLength);
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//---      
   SetIndexBuffer(0,IndBuffer1,INDICATOR_DATA);
//---      
   SetIndexBuffer(1,ColorIndBuffer1,INDICATOR_COLOR_INDEX);
//---      
   SetIndexBuffer(2,IndBuffer2,INDICATOR_DATA);   
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//---    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);
//---      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"XVolume(",XLength,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
  }
//+------------------------------------------------------------------+ 
//| XVolume iteration function                                       | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(0);
//---   
   int first,bar;
   long vol;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      if(VolumeType==VOLUME_TICK) vol=long(tick_volume[bar]);
         else vol=long(volume[bar]);
      IndBuffer2[bar]=XMA1.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength,vol,bar,false);
      IndBuffer1[bar]=double(vol);
      if(vol>IndBuffer2[bar]) ColorIndBuffer1[bar]=1;
      else ColorIndBuffer1[bar]=0;
     }
//---   
   return(rates_total);
  }
//+------------------------------------------------------------------+
